<div class="wrap super-demos">

    <h1>Super Forms - Demos</h1>

    <h2 class="screen-reader-text">Filter forms list</h2>

    <br class="clear">

    <?php
    $add_ons = array(
        'pdf_generator' => array(
            'title' => 'PDF Generator Add-on',
            'url' => 'https://renstillmann.github.io/super-forms/#/pdf-generator-add-on',
            'id' => '21048964',
        ),
        'email_reminders' => array(
            'title' => 'E-mail Reminders',
            'url' => 'https://renstillmann.github.io/super-forms/#/email-reminders',
            'id' => '21048964',
        ),
        'paypal' => array(
            'title' => 'PayPal',
            'url' => 'https://renstillmann.github.io/super-forms/#/paypal-checkout',
            'id' => '21048964',
        ),
        'mailster' => array(
            'title' => 'Mailster',
            'url' => 'https://renstillmann.github.io/super-forms/#/mailster',
            'id' => '19735910',
        ),
        'password_protect' => array(
            'title' => 'Password Protect & User Lockout & Hide',
            'url' => 'https://renstillmann.github.io/super-forms/#/password-protect-user-lockout-hide',
            'id' => '19604086',
        ),
        'zapier' => array(
            'title' => 'Zapier',
            'url' => 'https://renstillmann.github.io/super-forms/#/zapier',
            'id' => '19483649',
        ),
        'csv_attachment' => array(
            'title' => 'CSV Attachment',
            'url' => 'https://renstillmann.github.io/super-forms/#/csv-attachment',
            'id' => '19437918',
        ),
        'popups' => array(
            'title' => 'Popups',
            'id' => '19207307',
        ),
        'woocommerce' => array(
            'title' => 'WooCommerce Checkout',
            'id' => '18013799',
        ),
        'frontend_posting' => array(
            'title' => 'Front-end Posting',
            'id' => '17092502',
        ),
        'calculator' => array(
            'title' => 'Calculator',
            'url' => 'https://renstillmann.github.io/super-forms/#/calculator',
            'id' => '16045945',
        ),
        'signature' => array(
            'title' => 'Signature',
            'id' => '14879944',
        ),
        'email_templates' => array(
            'title' => 'Email Templates',
            'id' => '14468280',
        ),
        'register_login' => array(
            'title' => 'Register & Login',
            'url' => 'https://renstillmann.github.io/super-forms/#/register-login',
            'id' => '14403267',
        ),
        'mailchimp' => array(
            'title' => 'MailChimp',
            'url' => 'https://renstillmann.github.io/super-forms/#/mailchimp',
            'id' => '14126404',
        ),
    );

    $forms = array(
        
        // 'title' => '',
        // 'description' => '',
        // 'requirements' => '',
        // 'live_preview' => '',
        // 'elements' => '', // required for older super forms versions
        // 'settings' => '', // required for older super forms versions
        // 'import' => '', // @since 4.0.0 - for new super forms versions
        // 'date' => '2018-04-25',
        
        array(
            'title' => 'PDF Generator (Add-on)',
            'description' => 'Convert form submission to PDF and attach them to E-mails and or Contact entries, or allow instant download of the PDF.',
            'requirements' => 'pdf_generator',
            'live_preview' => 'http://f4d.nl/super-forms',
            'date' => '2020-07-17',
            'import' => 'a:4:{s:5:"title";s:3:"PDF";s:8:"settings";a:179:{s:4:"send";s:3:"yes";s:9:"header_to";s:20:"{option_admin_email}";s:16:"header_from_type";s:7:"default";s:20:"header_reply_enabled";s:0:"";s:14:"header_subject";s:12:"New question";s:15:"email_body_open";s:57:"The following information has been send by the submitter:";s:10:"email_body";s:46:"<table cellpadding=\"5\">{loop_fields}</table>";s:16:"email_body_close";s:31:"Best regards, {option_blogname}";s:10:"email_loop";s:82:"<tr><th valign=\"top\" align=\"right\">{loop_label}</th><td>{loop_value}</td></tr>";s:19:"email_exclude_empty";s:0:"";s:16:"email_body_nl2br";s:4:"true";s:9:"email_rtl";s:0:"";s:9:"header_cc";s:0:"";s:10:"header_bcc";s:0:"";s:17:"header_additional";s:0:"";s:7:"confirm";s:3:"yes";s:10:"confirm_to";s:7:"{email}";s:17:"confirm_from_type";s:7:"default";s:28:"confirm_header_reply_enabled";s:0:"";s:15:"confirm_subject";s:10:"Thank you!";s:17:"confirm_body_open";s:40:"Dear user,

Thank you for contacting us!";s:12:"confirm_body";s:46:"<table cellpadding=\"5\">{loop_fields}</table>";s:18:"confirm_body_close";s:63:"We will reply within 48 hours.

Best Regards, {option_blogname}";s:18:"confirm_email_loop";s:82:"<tr><th valign=\"top\" align=\"right\">{loop_label}</th><td>{loop_value}</td></tr>";s:21:"confirm_exclude_empty";s:0:"";s:18:"confirm_body_nl2br";s:4:"true";s:11:"confirm_rtl";s:0:"";s:17:"confirm_header_cc";s:0:"";s:18:"confirm_header_bcc";s:0:"";s:25:"confirm_header_additional";s:0:"";s:19:"header_content_type";s:4:"html";s:14:"header_charset";s:5:"UTF-8";s:17:"admin_attachments";s:0:"";s:19:"confirm_attachments";s:0:"";s:14:"email_template";s:22:"default_email_template";s:18:"save_contact_entry";s:3:"yes";s:27:"contact_entry_exclude_empty";s:0:"";s:24:"conditionally_save_entry";s:0:"";s:27:"contact_entry_custom_status";s:0:"";s:25:"enable_custom_entry_title";s:0:"";s:18:"save_form_progress";s:0:"";s:24:"retrieve_last_entry_data";s:0:"";s:20:"update_contact_entry";s:0:"";s:20:"form_show_thanks_msg";s:4:"true";s:17:"form_thanks_title";s:10:"Thank you!";s:23:"form_thanks_description";s:30:"We will reply within 24 hours.";s:12:"form_preload";s:1:"1";s:13:"form_duration";s:3:"500";s:16:"form_post_option";s:0:"";s:18:"form_disable_enter";s:0:"";s:20:"form_redirect_option";s:0:"";s:26:"form_hide_after_submitting";s:4:"true";s:27:"form_clear_after_submitting";s:0:"";s:13:"form_location";s:0:"";s:11:"form_locker";s:0:"";s:16:"user_form_locker";s:0:"";s:11:"theme_style";s:0:"";s:16:"theme_field_size";s:6:"medium";s:16:"theme_hide_icons";s:3:"yes";s:9:"theme_rtl";s:0:"";s:30:"theme_field_colors_placeholder";s:7:"#9a9a9a";s:26:"adaptive_placeholder_focus";s:7:"#4EB1B6";s:28:"enable_adaptive_placeholders";s:4:"true";s:32:"placeholder_adaptive_positioning";s:0:"";s:27:"adaptive_placeholder_filled";s:7:"#9a9a9a";s:33:"adaptive_placeholder_bg_top_focus";s:7:"#ffffff";s:36:"adaptive_placeholder_bg_bottom_focus";s:7:"#ffffff";s:34:"adaptive_placeholder_bg_top_filled";s:7:"#ffffff";s:37:"adaptive_placeholder_bg_bottom_filled";s:7:"#ffffff";s:33:"adaptive_placeholder_border_focus";s:0:"";s:34:"adaptive_placeholder_border_filled";s:0:"";s:17:"theme_center_form";s:0:"";s:15:"theme_max_width";s:1:"0";s:17:"theme_form_margin";s:15:"0px 0px 0px 0px";s:26:"theme_ui_loading_icon_font";s:7:"#c5c5c5";s:17:"theme_field_label";s:7:"#444444";s:23:"theme_field_description";s:7:"#8e8e8e";s:24:"theme_ui_checkbox_border";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_inner";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_label";s:7:"#444444";s:20:"theme_ui_quantity_bg";s:7:"#4EB1B6";s:22:"theme_ui_quantity_font";s:7:"#ffffff";s:26:"theme_ui_quantity_bg_hover";s:7:"#7ed0d4";s:28:"theme_ui_quantity_font_hover";s:7:"#ffffff";s:18:"theme_ui_toggle_bg";s:7:"#4EB1B6";s:20:"theme_ui_toggle_font";s:7:"#ffffff";s:27:"theme_ui_toggle_disabled_bg";s:7:"#e4e4e4";s:29:"theme_ui_toggle_disabled_font";s:7:"#9c9c9c";s:20:"theme_ui_keywords_bg";s:7:"#4EB1B6";s:22:"theme_ui_keywords_font";s:7:"#ffffff";s:22:"theme_ui_keywords_icon";s:7:"#2e8a90";s:28:"theme_ui_keywords_icon_hover";s:7:"#246569";s:16:"theme_ui_tags_bg";s:7:"#4EB1B6";s:18:"theme_ui_tags_font";s:7:"#ffffff";s:20:"theme_ui_tags_remove";s:7:"#2e8a90";s:26:"theme_ui_tags_remove_hover";s:7:"#246569";s:27:"theme_ui_tags_list_bg_hover";s:7:"#fdecde";s:23:"theme_ui_slider_dragger";s:7:"#4EB1B6";s:21:"theme_ui_slider_track";s:7:"#CDCDCD";s:22:"theme_field_colors_top";s:7:"#ffffff";s:25:"theme_field_colors_bottom";s:7:"#ffffff";s:25:"theme_field_colors_border";s:7:"#cdcdcd";s:23:"theme_field_colors_font";s:7:"#444444";s:28:"theme_field_colors_top_focus";s:7:"#ffffff";s:31:"theme_field_colors_bottom_focus";s:7:"#ffffff";s:31:"theme_field_colors_border_focus";s:7:"#4EB1B6";s:29:"theme_field_colors_font_focus";s:7:"#444444";s:23:"theme_field_transparent";s:0:"";s:18:"theme_rating_color";s:7:"#cdcdcd";s:15:"theme_rating_bg";s:7:"#ffffff";s:19:"theme_rating_border";s:7:"#cdcdcd";s:24:"theme_rating_color_hover";s:7:"#f7f188";s:21:"theme_rating_bg_hover";s:7:"#ffffff";s:25:"theme_rating_color_active";s:7:"#f7ea00";s:22:"theme_rating_bg_active";s:7:"#ffffff";s:28:"theme_multipart_progress_bar";s:4:"true";s:32:"theme_progress_bar_primary_color";s:7:"#87CC83";s:34:"theme_progress_bar_secondary_color";s:7:"#E2E2E2";s:31:"theme_progress_bar_border_color";s:7:"#CECECE";s:21:"theme_multipart_steps";s:4:"true";s:33:"theme_multipart_steps_hide_mobile";s:4:"true";s:33:"theme_progress_step_primary_color";s:7:"#CECECE";s:35:"theme_progress_step_secondary_color";s:7:"#E2E2E2";s:32:"theme_progress_step_border_color";s:7:"#CECECE";s:30:"theme_progress_step_font_color";s:7:"#FFFFFF";s:40:"theme_progress_step_primary_color_active";s:7:"#87CC83";s:42:"theme_progress_step_secondary_color_active";s:7:"#E2E2E2";s:39:"theme_progress_step_border_color_active";s:7:"#CECECE";s:37:"theme_progress_step_font_color_active";s:7:"#FFFFFF";s:16:"theme_error_font";s:7:"#f2322b";s:26:"theme_error_msg_font_color";s:7:"#D08080";s:28:"theme_error_msg_border_color";s:7:"#FFCBCB";s:24:"theme_error_msg_bg_color";s:7:"#FFEBEB";s:26:"theme_error_msg_icon_color";s:7:"#FF9A9A";s:28:"theme_success_msg_font_color";s:7:"#5E7F62";s:30:"theme_success_msg_border_color";s:7:"#90C397";s:26:"theme_success_msg_bg_color";s:7:"#C5FFCD";s:28:"theme_success_msg_icon_color";s:7:"#90C397";s:24:"theme_success_msg_margin";s:16:"0px 0px 30px 0px";s:16:"font_global_size";s:2:"12";s:15:"font_label_size";s:2:"16";s:21:"font_description_size";s:2:"14";s:17:"font_google_fonts";s:0:"";s:18:"font_global_family";s:0:"";s:15:"form_custom_css";s:0:"";s:11:"form_button";s:6:"Submit";s:19:"form_button_loading";s:10:"Loading...";s:18:"theme_button_color";s:7:"#f26c68";s:24:"theme_button_color_hover";s:7:"#444444";s:17:"theme_button_font";s:7:"#ffffff";s:23:"theme_button_font_hover";s:7:"#ffffff";s:18:"form_button_radius";s:6:"square";s:16:"form_button_type";s:4:"flat";s:16:"form_button_size";s:6:"medium";s:17:"form_button_align";s:4:"left";s:17:"form_button_width";s:4:"auto";s:23:"form_button_icon_option";s:4:"none";s:21:"csv_attachment_enable";s:0:"";s:16:"email_reminder_1";s:0:"";s:16:"email_reminder_2";s:0:"";s:16:"email_reminder_3";s:0:"";s:16:"email_reminder_4";s:0:"";s:16:"email_reminder_5";s:0:"";s:16:"email_reminder_6";s:0:"";s:16:"email_reminder_7";s:0:"";s:23:"frontend_posting_action";s:4:"none";s:16:"mailster_enabled";s:0:"";s:16:"password_protect";s:0:"";s:22:"password_protect_roles";s:0:"";s:22:"password_protect_login";s:0:"";s:31:"password_protect_not_login_hide";s:0:"";s:15:"paypal_checkout";s:0:"";s:21:"register_login_action";s:4:"none";s:15:"stripe_checkout";s:0:"";s:20:"woocommerce_checkout";s:0:"";s:13:"zapier_enable";s:0:"";s:11:"import-file";s:0:"";s:13:"popup_enabled";s:0:"";s:4:"_pdf";a:16:{s:8:"generate";s:4:"true";s:5:"debug";s:5:"false";s:8:"filename";s:8:"form.pdf";s:10:"emailLabel";s:9:"PDF File:";s:10:"adminEmail";s:4:"true";s:17:"confirmationEmail";s:4:"true";s:12:"excludeEntry";s:5:"false";s:11:"downloadBtn";s:4:"true";s:15:"downloadBtnText";s:16:"Download Summary";s:14:"generatingText";s:22:"Generating PDF file...";s:11:"orientation";s:8:"portrait";s:4:"unit";s:2:"mm";s:6:"format";s:2:"a4";s:12:"customFormat";s:0:"";s:7:"margins";a:3:{s:4:"body";a:4:{s:3:"top";s:1:"0";s:5:"right";s:1:"5";s:6:"bottom";s:1:"0";s:4:"left";s:1:"5";}s:6:"header";a:4:{s:3:"top";s:1:"5";s:5:"right";s:1:"5";s:6:"bottom";s:1:"5";s:4:"left";s:1:"5";}s:6:"footer";a:4:{s:3:"top";s:1:"5";s:5:"right";s:1:"5";s:6:"bottom";s:1:"5";s:4:"left";s:1:"5";}}s:11:"renderScale";s:1:"3";}}s:8:"elements";a:8:{i:0;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:2:{i:0;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:7:"heading";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:5:"title";s:32:"PDF HEADER (NOT VISIBLE IN FORM)";}}}s:4:"data";a:1:{s:4:"size";s:3:"2/3";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:4:"html";s:5:"group";s:13:"html_elements";s:4:"data";a:2:{s:4:"html";s:68:"<div style="float:right;">Page {pdf_page} of {pdf_total_pages}</div>";s:5:"nl2br";s:4:"true";}}}s:4:"data";a:1:{s:4:"size";s:3:"1/3";}}}s:4:"data";a:2:{s:5:"label";s:10:"PDF HEADER";s:9:"pdfOption";s:6:"header";}}i:1;a:3:{s:3:"tag";s:7:"heading";s:5:"group";s:13:"html_elements";s:4:"data";a:2:{s:5:"title";s:38:"PDF CONTENT/TEXT (NOT VISIBLE IN FORM)";s:9:"pdfOption";s:7:"include";}}i:2;a:3:{s:3:"tag";s:7:"heading";s:5:"group";s:13:"html_elements";s:4:"data";a:2:{s:5:"title";s:38:"FORM CONTENT/TEXT (NOT VISIBLE IN PDF)";s:9:"pdfOption";s:7:"exclude";}}i:3;a:3:{s:3:"tag";s:4:"html";s:5:"group";s:13:"html_elements";s:4:"data";a:5:{s:5:"title";s:47:"Some custom HTML inside PDF (not shown in form)";s:8:"subtitle";s:26:"Use any html you\'d like :)";s:4:"html";s:450:"<p style="color:red;">
Thank you for filling out this form, this is a HTML element with custom HTML. You can use your own HTML and it will be rendered in the PDF as is. For example:

<pre><xmp><strong style="color:red;">Red</strong></xmp></pre>

Would be rendered as:

<strong style="color:red;">Red</strong>.

This PDF generator is just awesome!
And of course you can use tags:
You entered the following E-mail address: <strong>{email}</strong>
</p>";s:5:"nl2br";s:4:"true";s:9:"pdfOption";s:7:"include";}}i:4;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:9:"pdfOption";s:7:"include";}}i:5;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:4:{i:0;a:3:{s:3:"tag";s:4:"text";s:5:"group";s:13:"form_elements";s:4:"data";a:7:{s:4:"name";s:5:"email";s:5:"email";s:14:"Email address:";s:11:"placeholder";s:19:"Your E-mail Address";s:17:"placeholderFilled";s:14:"E-mail Address";s:4:"type";s:5:"email";s:10:"validation";s:5:"email";s:4:"icon";s:12:"envelope;far";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:3:{s:3:"tag";s:5:"color";s:5:"group";s:13:"form_elements";s:4:"data";a:3:{s:4:"name";s:5:"color";s:5:"email";s:6:"Color:";s:4:"icon";s:11:"eye-dropper";}}i:1;a:3:{s:3:"tag";s:8:"quantity";s:5:"group";s:13:"form_elements";s:4:"data";a:2:{s:4:"name";s:10:"quantity_1";s:5:"email";s:9:"Quantity:";}}i:2;a:3:{s:3:"tag";s:8:"checkbox";s:5:"group";s:13:"form_elements";s:4:"data";a:4:{s:4:"name";s:8:"option_1";s:5:"email";s:7:"Option:";s:4:"icon";s:16:"check-square;far";s:14:"checkbox_items";a:3:{i:0;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:12:"First choice";s:5:"value";s:12:"first_choice";}i:1;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:13:"Second choice";s:5:"value";s:13:"second_choice";}i:2;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:12:"Third choice";s:5:"value";s:12:"third_choice";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/4";}}i:2;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:3:{s:3:"tag";s:6:"toggle";s:5:"group";s:13:"form_elements";s:4:"data";a:3:{s:4:"name";s:8:"quantity";s:5:"email";s:9:"Quantity:";s:4:"icon";s:9:"toggle-on";}}i:1;a:3:{s:3:"tag";s:6:"rating";s:5:"group";s:13:"form_elements";s:4:"data";a:4:{s:4:"name";s:6:"rating";s:5:"email";s:7:"Rating:";s:10:"validation";s:4:"none";s:4:"icon";s:5:"heart";}}i:2;a:3:{s:3:"tag";s:5:"radio";s:5:"group";s:13:"form_elements";s:4:"data";a:4:{s:4:"name";s:8:"option_2";s:5:"email";s:7:"Option:";s:4:"icon";s:14:"dot-circle;far";s:11:"radio_items";a:3:{i:0;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:12:"First choice";s:5:"value";s:12:"first_choice";}i:1;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:13:"Second choice";s:5:"value";s:13:"second_choice";}i:2;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:12:"Third choice";s:5:"value";s:12:"third_choice";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/4";}}i:3;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:3:{s:3:"tag";s:8:"textarea";s:5:"group";s:13:"form_elements";s:4:"data";a:5:{s:4:"name";s:8:"question";s:5:"email";s:9:"Question:";s:11:"placeholder";s:23:"Ask us any questions...";s:17:"placeholderFilled";s:8:"Question";s:4:"icon";s:8:"question";}}i:1;a:3:{s:3:"tag";s:6:"slider";s:5:"group";s:13:"form_elements";s:4:"data";a:6:{s:4:"name";s:6:"amount";s:5:"email";s:7:"Amount:";s:5:"value";s:1:"0";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:4:"icon";s:9:"sliders-h";}}i:2;a:3:{s:3:"tag";s:8:"dropdown";s:5:"group";s:13:"form_elements";s:4:"data";a:5:{s:4:"name";s:6:"option";s:5:"email";s:7:"Option:";s:11:"placeholder";s:19:"- select a option -";s:4:"icon";s:21:"caret-square-down;far";s:14:"dropdown_items";a:3:{i:0;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:12:"First choice";s:5:"value";s:12:"first_choice";}i:1;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:13:"Second choice";s:5:"value";s:13:"second_choice";}i:2;a:3:{s:7:"checked";s:5:"false";s:5:"label";s:12:"Third choice";s:5:"value";s:12:"third_choice";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/2";}}}}i:6;a:3:{s:3:"tag";s:9:"signature";s:5:"group";s:13:"form_elements";s:4:"data";a:3:{s:4:"name";s:9:"signature";s:5:"email";s:10:"Signature:";s:4:"icon";s:9:"signature";}}i:7;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:2:{i:0;a:3:{s:3:"tag";s:7:"heading";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:5:"title";s:32:"PDF FOOTER (NOT VISIBLE IN FORM)";}}i:1;a:3:{s:3:"tag";s:4:"html";s:5:"group";s:13:"html_elements";s:4:"data";a:2:{s:4:"html";s:68:"<div style="float:right;">Page {pdf_page} of {pdf_total_pages}</div>";s:5:"nl2br";s:4:"true";}}}s:4:"data";a:2:{s:5:"label";s:10:"PDF FOOTER";s:9:"pdfOption";s:6:"footer";}}}s:12:"translations";a:1:{s:2:"af";a:3:{s:8:"language";s:9:"Afrikaans";s:4:"flag";s:2:"dz";s:3:"rtl";b:0;}}}'
        ),
        array(
            'title' => 'E-mail & Appointment Reminders',
            'description' => 'Send reminders to your customers or users based on specific dates and times',
            'requirements' => 'email_reminders',
            'live_preview' => 'http://f4d.nl/super-forms/documentation/email-reminders/',
            'date' => '2019-05-25',
            'import' => 'a:3:{s:5:"title";s:14:"Email Reminder";s:8:"settings";a:167:{s:4:"send";s:3:"yes";s:9:"header_to";s:7:"{email}";s:16:"header_from_type";s:6:"custom";s:11:"header_from";s:15:"no-reply@f4d.nl";s:16:"header_from_name";s:11:"Super Forms";s:20:"header_reply_enabled";s:0:"";s:14:"header_subject";s:12:"New question";s:15:"email_body_open";s:57:"The following information has been send by the submitter:";s:10:"email_body";s:44:"<table cellpadding="5">{loop_fields}</table>";s:16:"email_body_close";s:31:"Best regards, {option_blogname}";s:10:"email_loop";s:78:"<tr><th valign="top" align="right">{loop_label}</th><td>{loop_value}</td></tr>";s:19:"email_exclude_empty";s:0:"";s:16:"email_body_nl2br";s:4:"true";s:9:"header_cc";s:0:"";s:10:"header_bcc";s:0:"";s:17:"header_additional";s:0:"";s:7:"confirm";s:2:"no";s:19:"header_content_type";s:4:"html";s:14:"header_charset";s:5:"UTF-8";s:17:"admin_attachments";s:0:"";s:19:"confirm_attachments";s:0:"";s:14:"email_template";s:22:"default_email_template";s:18:"save_contact_entry";s:2:"no";s:18:"save_form_progress";s:0:"";s:20:"update_contact_entry";s:0:"";s:24:"retrieve_last_entry_data";s:0:"";s:20:"form_show_thanks_msg";s:4:"true";s:17:"form_thanks_title";s:10:"Thank you!";s:23:"form_thanks_description";s:30:"We will reply within 24 hours.";s:12:"form_preload";s:1:"1";s:13:"form_duration";s:3:"500";s:16:"form_post_option";s:0:"";s:18:"form_disable_enter";s:0:"";s:20:"form_redirect_option";s:0:"";s:26:"form_hide_after_submitting";s:4:"true";s:27:"form_clear_after_submitting";s:0:"";s:11:"form_locker";s:0:"";s:16:"user_form_locker";s:0:"";s:11:"theme_style";s:0:"";s:16:"theme_field_size";s:6:"medium";s:16:"theme_hide_icons";s:3:"yes";s:17:"theme_center_form";s:0:"";s:15:"theme_max_width";s:1:"0";s:17:"theme_form_margin";s:15:"0px 0px 0px 0px";s:9:"theme_rtl";s:0:"";s:26:"theme_ui_loading_icon_font";s:7:"#c5c5c5";s:17:"theme_field_label";s:7:"#444444";s:23:"theme_field_description";s:7:"#8e8e8e";s:24:"theme_ui_checkbox_border";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_inner";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_label";s:7:"#444444";s:20:"theme_ui_quantity_bg";s:7:"#4EB1B6";s:22:"theme_ui_quantity_font";s:7:"#ffffff";s:26:"theme_ui_quantity_bg_hover";s:7:"#7ed0d4";s:28:"theme_ui_quantity_font_hover";s:7:"#ffffff";s:18:"theme_ui_toggle_bg";s:7:"#4EB1B6";s:20:"theme_ui_toggle_font";s:7:"#ffffff";s:27:"theme_ui_toggle_disabled_bg";s:7:"#e4e4e4";s:29:"theme_ui_toggle_disabled_font";s:7:"#9c9c9c";s:20:"theme_ui_keywords_bg";s:7:"#4EB1B6";s:22:"theme_ui_keywords_font";s:7:"#ffffff";s:22:"theme_ui_keywords_icon";s:7:"#2e8a90";s:28:"theme_ui_keywords_icon_hover";s:7:"#246569";s:16:"theme_ui_tags_bg";s:7:"#4EB1B6";s:18:"theme_ui_tags_font";s:7:"#ffffff";s:20:"theme_ui_tags_remove";s:7:"#2e8a90";s:26:"theme_ui_tags_remove_hover";s:7:"#246569";s:27:"theme_ui_tags_list_bg_hover";s:7:"#fdecde";s:23:"theme_ui_slider_dragger";s:7:"#4EB1B6";s:21:"theme_ui_slider_track";s:7:"#CDCDCD";s:22:"theme_field_colors_top";s:7:"#ffffff";s:25:"theme_field_colors_bottom";s:7:"#ffffff";s:25:"theme_field_colors_border";s:7:"#cdcdcd";s:23:"theme_field_colors_font";s:7:"#444444";s:30:"theme_field_colors_placeholder";s:7:"#444444";s:28:"theme_field_colors_top_focus";s:7:"#ffffff";s:31:"theme_field_colors_bottom_focus";s:7:"#ffffff";s:31:"theme_field_colors_border_focus";s:7:"#cdcdcd";s:29:"theme_field_colors_font_focus";s:7:"#444444";s:36:"theme_field_colors_placeholder_focus";s:7:"#444444";s:23:"theme_field_transparent";s:0:"";s:18:"theme_rating_color";s:7:"#cdcdcd";s:15:"theme_rating_bg";s:7:"#ffffff";s:19:"theme_rating_border";s:7:"#cdcdcd";s:24:"theme_rating_color_hover";s:7:"#f7f188";s:21:"theme_rating_bg_hover";s:7:"#ffffff";s:25:"theme_rating_color_active";s:7:"#f7ea00";s:22:"theme_rating_bg_active";s:7:"#ffffff";s:28:"theme_multipart_progress_bar";s:4:"true";s:32:"theme_progress_bar_primary_color";s:7:"#87CC83";s:34:"theme_progress_bar_secondary_color";s:7:"#E2E2E2";s:31:"theme_progress_bar_border_color";s:7:"#CECECE";s:21:"theme_multipart_steps";s:4:"true";s:33:"theme_multipart_steps_hide_mobile";s:4:"true";s:33:"theme_progress_step_primary_color";s:7:"#CECECE";s:35:"theme_progress_step_secondary_color";s:7:"#E2E2E2";s:32:"theme_progress_step_border_color";s:7:"#CECECE";s:30:"theme_progress_step_font_color";s:7:"#FFFFFF";s:40:"theme_progress_step_primary_color_active";s:7:"#87CC83";s:42:"theme_progress_step_secondary_color_active";s:7:"#E2E2E2";s:39:"theme_progress_step_border_color_active";s:7:"#CECECE";s:37:"theme_progress_step_font_color_active";s:7:"#FFFFFF";s:16:"theme_error_font";s:7:"#f2322b";s:26:"theme_error_msg_font_color";s:7:"#D08080";s:28:"theme_error_msg_border_color";s:7:"#FFCBCB";s:24:"theme_error_msg_bg_color";s:7:"#FFEBEB";s:26:"theme_error_msg_icon_color";s:7:"#FF9A9A";s:28:"theme_success_msg_font_color";s:7:"#5E7F62";s:30:"theme_success_msg_border_color";s:7:"#90C397";s:26:"theme_success_msg_bg_color";s:7:"#C5FFCD";s:28:"theme_success_msg_icon_color";s:7:"#90C397";s:24:"theme_success_msg_margin";s:16:"0px 0px 30px 0px";s:16:"font_global_size";s:2:"12";s:15:"font_label_size";s:2:"16";s:21:"font_description_size";s:2:"14";s:17:"font_google_fonts";s:0:"";s:18:"font_global_family";s:0:"";s:15:"form_custom_css";s:0:"";s:11:"form_button";s:6:"Submit";s:19:"form_button_loading";s:10:"Loading...";s:18:"theme_button_color";s:7:"#f26c68";s:24:"theme_button_color_hover";s:7:"#444444";s:17:"theme_button_font";s:7:"#ffffff";s:23:"theme_button_font_hover";s:7:"#ffffff";s:18:"form_button_radius";s:6:"square";s:16:"form_button_type";s:4:"flat";s:16:"form_button_size";s:6:"medium";s:17:"form_button_align";s:4:"left";s:17:"form_button_width";s:4:"auto";s:23:"form_button_icon_option";s:4:"none";s:21:"csv_attachment_enable";s:0:"";s:16:"email_reminder_1";s:4:"true";s:26:"email_reminder_1_base_date";s:0:"";s:28:"email_reminder_1_date_offset";s:1:"0";s:28:"email_reminder_1_time_method";s:6:"offset";s:28:"email_reminder_1_time_offset";s:3:"0.1";s:19:"email_reminder_1_to";s:7:"{email}";s:26:"email_reminder_1_from_type";s:6:"custom";s:21:"email_reminder_1_from";s:15:"no-reply@f4d.nl";s:26:"email_reminder_1_from_name";s:11:"Super Forms";s:37:"email_reminder_1_header_reply_enabled";s:0:"";s:24:"email_reminder_1_subject";s:23:"Example E-mail Reminder";s:26:"email_reminder_1_body_open";s:287:"Dear user,

This is an example reminder, for more information about this visit: 

<a href="https://renstillmann.github.io/super-forms/#/email-reminders">https://renstillmann.github.io/super-forms/#/email-reminders</a>

Below you will find the information your provided through the form:
";s:21:"email_reminder_1_body";s:44:"<table cellpadding="5">{loop_fields}</table>";s:27:"email_reminder_1_body_close";s:31:"Best Regards, {option_blogname}";s:27:"email_reminder_1_email_loop";s:78:"<tr><th valign="top" align="right">{loop_label}</th><td>{loop_value}</td></tr>";s:30:"email_reminder_1_exclude_empty";s:0:"";s:27:"email_reminder_1_body_nl2br";s:4:"true";s:26:"email_reminder_1_header_cc";s:0:"";s:27:"email_reminder_1_header_bcc";s:0:"";s:34:"email_reminder_1_header_additional";s:0:"";s:28:"email_reminder_1_attachments";s:0:"";s:16:"email_reminder_2";s:0:"";s:16:"email_reminder_3";s:0:"";s:23:"frontend_posting_action";s:4:"none";s:16:"mailster_enabled";s:0:"";s:16:"password_protect";s:0:"";s:22:"password_protect_roles";s:0:"";s:22:"password_protect_login";s:0:"";s:31:"password_protect_not_login_hide";s:0:"";s:15:"paypal_checkout";s:0:"";s:21:"register_login_action";s:4:"none";s:23:"wc_custom_orders_action";s:4:"none";s:20:"woocommerce_checkout";s:0:"";s:13:"zapier_enable";s:0:"";s:11:"import-file";s:0:"";s:13:"popup_enabled";s:0:"";}s:8:"elements";a:4:{i:0;a:3:{s:3:"tag";s:7:"heading";s:5:"group";s:13:"html_elements";s:4:"data";a:3:{s:4:"desc";s:430:"Enter your real E-mail address to receive the reminder (your email address will not be stored). You should receive 2 emails after submitting the form, the first one will be send immediately. The second one will be send after 5 minutes (for demonstration purposes). Please understand that you might receive these emails shortly after each other, just look at the date and time of the email being delivered/send in your mail client!";s:13:"heading_color";s:7:"#ff0000";s:10:"desc_color";s:7:"#ff0000";}}i:1;a:3:{s:3:"tag";s:4:"text";s:5:"group";s:13:"form_elements";s:4:"data";a:7:{s:4:"name";s:5:"email";s:5:"email";s:14:"Email address:";s:11:"placeholder";s:18:"Your Email Address";s:4:"type";s:5:"email";s:10:"validation";s:5:"email";s:5:"error";s:92:"Provide your real email address to receive E-mail reminders, this is just for demo purposes!";s:4:"icon";s:12:"envelope;far";}}i:2;a:3:{s:3:"tag";s:8:"textarea";s:5:"group";s:13:"form_elements";s:4:"data";a:6:{s:4:"name";s:8:"question";s:5:"email";s:9:"Question:";s:11:"placeholder";s:23:"Ask us any questions...";s:10:"validation";s:5:"empty";s:5:"error";s:59:"This field is required, please just type something randomly";s:4:"icon";s:8:"question";}}i:3;a:3:{s:3:"tag";s:5:"radio";s:5:"group";s:13:"form_elements";s:4:"data";a:8:{s:4:"name";s:6:"option";s:5:"email";s:7:"Option:";s:11:"radio_items";a:3:{i:0;a:4:{s:7:"checked";s:0:"";s:5:"image";s:0:"";s:5:"label";s:12:"First choice";s:5:"value";s:12:"first_choice";}i:1;a:4:{s:7:"checked";s:0:"";s:5:"image";s:0:"";s:5:"label";s:13:"Second choice";s:5:"value";s:13:"second_choice";}i:2;a:4:{s:7:"checked";s:0:"";s:5:"image";s:0:"";s:5:"label";s:12:"Third choice";s:5:"value";s:12:"third_choice";}}s:17:"admin_email_value";s:5:"label";s:19:"confirm_email_value";s:5:"label";s:10:"validation";s:5:"empty";s:5:"error";s:61:"Just choose one of the three options, just for demo purposes!";s:4:"icon";s:14:"dot-circle;far";}}}}'
        ),

        array(            
            'title' => 'WooCommerce Dynamic Pricing',
            'description' => 'Dynamically add a price to the product(s) added to the cart. Checkout users and set a price based on user selected options.',
            'requirements' => 'woocommerce,calculator,<a target="_blank" href="https://woocommerce.com/products/name-your-price/">Name Your Price</a>',
            'live_preview' => 'http://f4d.nl/super-forms/documentation/woocommerce-checkout/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"radio","group":"form_elements","data":{"radio_items":[{"checked":true,"image":"","label":"None","value":"0"},{"checked":false,"image":"","label":"1 (Free)","value":"0"},{"checked":false,"image":"","label":"2 - 5","value":"6"},{"checked":false,"image":"","label":"5+","value":"10"}],"name":"emails","email":"Total emails:","label":"Total of email addresses","description":"How many email addresses you need for your domain?","validation":"empty","display":"horizontal","icon":"paper-plane-o","conditional_items":[{"field":"emails","logic":"contains","value":"","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}}],"data":{"size":"2/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"math":"{emails}","currency":"$","thousand_separator":",","name":"total_email","email":"Email total:","label":" ","description":" ","align":"right","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":""}]}}],"data":{"size":"1/3"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"quantity","group":"form_elements","data":{"name":"domains","email":"Domains","label":"Total of domain names","description":"Select how many domain names you want to register","value":"0","icon_position":"outside","icon_align":"left","icon":"user","conditional_items":[{"field":"emails","logic":"","value":"","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}}],"data":{"size":"2/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_domains","math":"{domains}*1.8","currency":"$","thousand_separator":",","email":"Email total:","label":" ","description":" ","align":"right","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":"","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}}],"data":{"size":"1/3"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"checkbox","group":"form_elements","data":{"checkbox_items":[{"checked":false,"image":"","label":"Malware scans","value":"0"},{"checked":false,"image":"","label":"Daily Backup ($3)","value":"3"},{"checked":false,"image":"","label":"Montly updates ($10)","value":"10"}],"name":"protection","email":"Protection:","label":"Website anti-virus, backups and updates","description":"Select all the protections  you want","display":"horizontal","icon":"bug","conditional_items":[{"field":"emails","logic":"contains","value":"","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}}],"data":{"size":"3/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"math":"{protection}","currency":"$","thousand_separator":",","name":"total_protection","email":"Protection total:","label":" ","description":" ","align":"right","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":""}]}}],"data":{"size":"1/4"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"slider","group":"form_elements","data":{"name":"scans","email":"Storage:","label":"Select how many scans you want per week","description":"How many Malware scans do you want per week?","value":"1","format":" scan p/w","decimals":"0","minnumber":"1","maxnumber":"50","icon":"database"}}],"data":{"size":"2/3","conditional_items":[{"field":"emails","logic":"contains","value":""}]}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"math":"{scans}*5","currency":"$","thousand_separator":",","name":"total_scans","email":"Scans total:","label":" ","description":" ","align":"right","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":""}]}}],"data":{"size":"1/3","conditional_items":[{"field":"emails","logic":"contains","value":""}]}}],"data":{"conditional_action":"show","conditional_items":[{"field":"protection","logic":"contains","value":"0"}]}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"slider","group":"form_elements","data":{"name":"storage","email":"Storage:","label":"Select your total storage","description":"How much storage would you need on your new server?","value":"20","format":" GB","thousand_separator":",","minnumber":"10","icon":"database"}}],"data":{"size":"2/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"math":"{storage}*1.5","currency":"$","thousand_separator":",","name":"total_storage","email":"Storage total:","label":" ","description":" ","align":"right","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":""}]}}],"data":{"size":"1/3"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"checkbox","group":"form_elements","data":{"checkbox_items":[{"checked":false,"image":"","label":"Off-site SEO ($6)","value":"6"},{"checked":false,"image":"","label":"On-site SEO ($10)","value":"10"}],"name":"seo","email":"SEO:","label":"Optimise my website for search engines","description":"Select if you would like Off-site and/or On-site optimisation:","display":"horizontal","icon":"tachometer","conditional_items":[{"field":"emails","logic":"contains","value":"","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}}],"data":{"size":"3/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"math":"{seo}","currency":"$","thousand_separator":",","name":"total_seo","email":"SEO total:","label":" ","description":" ","align":"right","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":""}]}}],"data":{"size":"1/4"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"subtotal","math":"{total_email}+{total_domains}+{total_protection}+{total_scans}+{total_storage}+{total_seo}","amount_label":"Subtotal:","currency":"$","thousand_separator":",","email":"Subtotal:","align":"right","amount_width":"100","margin":"no_margin","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":"","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}},{"tag":"calculator","group":"form_elements","data":{"name":"vat","math":"({subtotal}/100)*21","amount_label":"VAT (21%):","currency":"$","thousand_separator":",","email":"VAT:","align":"right","amount_width":"100","margin":"no_margin","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":""}]}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"3/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"divider","group":"html_elements","data":{"padding_top":"10","padding_bottom":"10"}}],"data":{"size":"1/4"}},{"tag":"calculator","group":"form_elements","data":{"name":"total","math":"{subtotal}+{vat}","amount_label":"Total:","currency":"$","thousand_separator":",","email_float":"true","email":"Total:","align":"right","amount_width":"100","margin":"no_margin","icon_position":"inside","conditional_items":[{"field":"emails","logic":"contains","value":"","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}},{"tag":"spacer","group":"html_elements"},{"tag":"button","group":"form_elements","data":{"name":"Setup my WordPress website!","color":"#f26c68","color_hover":"#444444","font":"#ffffff","font_hover":"#ffffff","type":"2d"}}]}]',
            'settings' => '{"send":"yes","header_to":"{email}","header_from_type":"default","header_reply_enabled":"","header_subject":"Super Forms","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_header_reply_enabled":"","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","admin_attachments":"","confirm_attachments":"","email_template":"default_email_template","save_contact_entry":"yes","conditionally_save_entry":"","contact_entry_custom_status":"","enable_custom_entry_title":"","save_form_progress":"","update_contact_entry":"","retrieve_last_entry_data":"","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_duration":"500","form_post_option":"","form_disable_enter":"","form_redirect_option":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","form_locker":"","user_form_locker":"","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_center_form":"","theme_rtl":"","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"","theme_field_description":"","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_tags_bg":"#4EB1B6","theme_ui_tags_font":"#ffffff","theme_ui_tags_remove":"#2e8a90","theme_ui_tags_remove_hover":"#246569","theme_ui_tags_list_bg_hover":"#fdecde","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_multipart_progress_bar":"true","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_multipart_steps":"true","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":"12","font_label_size":"16","font_description_size":"14","font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","csv_attachment_enable":"","frontend_posting_action":"none","password_protect":"","password_protect_roles":"","password_protect_login":"","password_protect_not_login_hide":"","paypal_checkout":"","register_login_action":"none","woocommerce_checkout":"true","woocommerce_checkout_empty_cart":"true","woocommerce_checkout_remove_coupons":"true","woocommerce_checkout_remove_fees":"true","woocommerce_checkout_products":"29413|1|none|{total}","woocommerce_checkout_products_meta":"29413|Email addresses|{emails;label}\n29413|Total domain names|{domains}\n29413|Protection|{protection;label}\n29413|Malware scans per week|{scans}\n29413|Storage|{storage} GB\n29413|SEO|{seo;label}\n\n","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_checkout_fields":"","woocommerce_checkout_fields_skip_empty":"","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","import-file":"","popup_enabled":""}',
            'import' => 'a:3:{s:5:"title";s:20:"WordPress Site Setup";s:8:"settings";a:163:{s:4:"send";s:3:"yes";s:9:"header_to";s:7:"{email}";s:16:"header_from_type";s:7:"default";s:20:"header_reply_enabled";s:0:"";s:14:"header_subject";s:11:"Super Forms";s:15:"email_body_open";s:57:"The following information has been send by the submitter:";s:10:"email_body";s:44:"<table cellpadding="5">{loop_fields}</table>";s:16:"email_body_close";s:31:"Best regards, {option_blogname}";s:10:"email_loop";s:78:"<tr><th valign="top" align="right">{loop_label}</th><td>{loop_value}</td></tr>";s:16:"email_body_nl2br";s:4:"true";s:9:"header_cc";s:0:"";s:10:"header_bcc";s:0:"";s:17:"header_additional";s:0:"";s:7:"confirm";s:3:"yes";s:10:"confirm_to";s:7:"{email}";s:17:"confirm_from_type";s:7:"default";s:28:"confirm_header_reply_enabled";s:0:"";s:15:"confirm_subject";s:10:"Thank you!";s:17:"confirm_body_open";s:40:"Dear user,

Thank you for contacting us!";s:12:"confirm_body";s:44:"<table cellpadding="5">{loop_fields}</table>";s:18:"confirm_body_close";s:63:"We will reply within 48 hours.

Best Regards, {option_blogname}";s:18:"confirm_body_nl2br";s:4:"true";s:17:"confirm_header_cc";s:0:"";s:18:"confirm_header_bcc";s:0:"";s:25:"confirm_header_additional";s:0:"";s:19:"header_content_type";s:4:"html";s:14:"header_charset";s:5:"UTF-8";s:17:"admin_attachments";s:0:"";s:19:"confirm_attachments";s:0:"";s:14:"email_template";s:22:"default_email_template";s:18:"save_contact_entry";s:3:"yes";s:24:"conditionally_save_entry";s:0:"";s:27:"contact_entry_custom_status";s:0:"";s:25:"enable_custom_entry_title";s:0:"";s:18:"save_form_progress";s:0:"";s:20:"update_contact_entry";s:0:"";s:24:"retrieve_last_entry_data";s:0:"";s:20:"form_show_thanks_msg";s:4:"true";s:17:"form_thanks_title";s:10:"Thank you!";s:23:"form_thanks_description";s:30:"We will reply within 24 hours.";s:12:"form_preload";s:1:"1";s:13:"form_duration";s:3:"500";s:16:"form_post_option";s:0:"";s:18:"form_disable_enter";s:0:"";s:20:"form_redirect_option";s:0:"";s:26:"form_hide_after_submitting";s:4:"true";s:27:"form_clear_after_submitting";s:0:"";s:11:"form_locker";s:0:"";s:16:"user_form_locker";s:0:"";s:11:"theme_style";s:0:"";s:16:"theme_field_size";s:6:"medium";s:16:"theme_hide_icons";s:3:"yes";s:17:"theme_center_form";s:0:"";s:9:"theme_rtl";s:0:"";s:26:"theme_ui_loading_icon_font";s:7:"#c5c5c5";s:17:"theme_field_label";s:0:"";s:23:"theme_field_description";s:0:"";s:24:"theme_ui_checkbox_border";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_inner";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_label";s:7:"#444444";s:20:"theme_ui_quantity_bg";s:7:"#4EB1B6";s:22:"theme_ui_quantity_font";s:7:"#ffffff";s:26:"theme_ui_quantity_bg_hover";s:7:"#7ed0d4";s:28:"theme_ui_quantity_font_hover";s:7:"#ffffff";s:18:"theme_ui_toggle_bg";s:7:"#4EB1B6";s:20:"theme_ui_toggle_font";s:7:"#ffffff";s:27:"theme_ui_toggle_disabled_bg";s:7:"#e4e4e4";s:29:"theme_ui_toggle_disabled_font";s:7:"#9c9c9c";s:20:"theme_ui_keywords_bg";s:7:"#4EB1B6";s:22:"theme_ui_keywords_font";s:7:"#ffffff";s:22:"theme_ui_keywords_icon";s:7:"#2e8a90";s:28:"theme_ui_keywords_icon_hover";s:7:"#246569";s:16:"theme_ui_tags_bg";s:7:"#4EB1B6";s:18:"theme_ui_tags_font";s:7:"#ffffff";s:20:"theme_ui_tags_remove";s:7:"#2e8a90";s:26:"theme_ui_tags_remove_hover";s:7:"#246569";s:27:"theme_ui_tags_list_bg_hover";s:7:"#fdecde";s:23:"theme_ui_slider_dragger";s:7:"#4EB1B6";s:21:"theme_ui_slider_track";s:7:"#CDCDCD";s:22:"theme_field_colors_top";s:7:"#ffffff";s:25:"theme_field_colors_bottom";s:7:"#ffffff";s:25:"theme_field_colors_border";s:7:"#cdcdcd";s:23:"theme_field_colors_font";s:7:"#444444";s:30:"theme_field_colors_placeholder";s:7:"#444444";s:28:"theme_field_colors_top_focus";s:7:"#ffffff";s:31:"theme_field_colors_bottom_focus";s:7:"#ffffff";s:31:"theme_field_colors_border_focus";s:7:"#cdcdcd";s:29:"theme_field_colors_font_focus";s:7:"#444444";s:36:"theme_field_colors_placeholder_focus";s:7:"#444444";s:23:"theme_field_transparent";s:0:"";s:18:"theme_rating_color";s:7:"#cdcdcd";s:15:"theme_rating_bg";s:7:"#ffffff";s:19:"theme_rating_border";s:7:"#cdcdcd";s:24:"theme_rating_color_hover";s:7:"#f7f188";s:21:"theme_rating_bg_hover";s:7:"#ffffff";s:25:"theme_rating_color_active";s:7:"#f7ea00";s:22:"theme_rating_bg_active";s:7:"#ffffff";s:28:"theme_multipart_progress_bar";s:4:"true";s:32:"theme_progress_bar_primary_color";s:7:"#87CC83";s:34:"theme_progress_bar_secondary_color";s:7:"#E2E2E2";s:31:"theme_progress_bar_border_color";s:7:"#CECECE";s:21:"theme_multipart_steps";s:4:"true";s:33:"theme_progress_step_primary_color";s:7:"#CECECE";s:35:"theme_progress_step_secondary_color";s:7:"#E2E2E2";s:32:"theme_progress_step_border_color";s:7:"#CECECE";s:30:"theme_progress_step_font_color";s:7:"#FFFFFF";s:40:"theme_progress_step_primary_color_active";s:7:"#87CC83";s:42:"theme_progress_step_secondary_color_active";s:7:"#E2E2E2";s:39:"theme_progress_step_border_color_active";s:7:"#CECECE";s:37:"theme_progress_step_font_color_active";s:7:"#FFFFFF";s:16:"theme_error_font";s:7:"#f2322b";s:26:"theme_error_msg_font_color";s:7:"#D08080";s:28:"theme_error_msg_border_color";s:7:"#FFCBCB";s:24:"theme_error_msg_bg_color";s:7:"#FFEBEB";s:26:"theme_error_msg_icon_color";s:7:"#FFCBCB";s:28:"theme_success_msg_font_color";s:7:"#5E7F62";s:30:"theme_success_msg_border_color";s:7:"#90C397";s:26:"theme_success_msg_bg_color";s:7:"#C5FFCD";s:28:"theme_success_msg_icon_color";s:7:"#90C397";s:24:"theme_success_msg_margin";s:16:"0px 0px 30px 0px";s:15:"theme_max_width";s:1:"0";s:17:"theme_form_margin";s:15:"0px 0px 0px 0px";s:16:"font_global_size";s:2:"12";s:15:"font_label_size";s:2:"16";s:21:"font_description_size";s:2:"14";s:17:"font_google_fonts";s:0:"";s:18:"font_global_family";s:0:"";s:15:"form_custom_css";s:0:"";s:11:"form_button";s:6:"Submit";s:19:"form_button_loading";s:10:"Loading...";s:18:"theme_button_color";s:7:"#3f9b4d";s:24:"theme_button_color_hover";s:7:"#007001";s:17:"theme_button_font";s:7:"#ffffff";s:23:"theme_button_font_hover";s:7:"#ffffff";s:18:"form_button_radius";s:6:"square";s:16:"form_button_type";s:4:"flat";s:16:"form_button_size";s:6:"medium";s:17:"form_button_align";s:5:"right";s:17:"form_button_width";s:4:"auto";s:23:"form_button_icon_option";s:4:"none";s:21:"csv_attachment_enable";s:0:"";s:23:"frontend_posting_action";s:4:"none";s:16:"password_protect";s:0:"";s:22:"password_protect_roles";s:0:"";s:22:"password_protect_login";s:0:"";s:31:"password_protect_not_login_hide";s:0:"";s:15:"paypal_checkout";s:0:"";s:21:"register_login_action";s:4:"none";s:20:"woocommerce_checkout";s:4:"true";s:31:"woocommerce_checkout_empty_cart";s:4:"true";s:35:"woocommerce_checkout_remove_coupons";s:4:"true";s:32:"woocommerce_checkout_remove_fees";s:4:"true";s:29:"woocommerce_checkout_products";s:20:"29413|1|none|{total}";s:34:"woocommerce_checkout_products_meta";s:195:"29413|Email addresses|{emails;label}
29413|Total domain names|{domains}
29413|Protection|{protection;label}
29413|Malware scans per week|{scans}
29413|Storage|{storage} GB
29413|SEO|{seo;label}

";s:27:"woocommerce_checkout_coupon";s:0:"";s:25:"woocommerce_checkout_fees";s:41:"{fee_name}|{amount}|{taxable}|{tax_class}";s:27:"woocommerce_checkout_fields";s:0:"";s:38:"woocommerce_checkout_fields_skip_empty";s:0:"";s:20:"woocommerce_redirect";s:8:"checkout";s:23:"woocommerce_post_status";s:7:"publish";s:25:"woocommerce_signup_status";s:6:"active";s:11:"import-file";s:0:"";s:13:"popup_enabled";s:0:"";}s:8:"elements";a:6:{i:0;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:5:"radio";s:5:"group";s:13:"form_elements";s:4:"data";a:9:{s:11:"radio_items";a:4:{i:0;a:4:{s:7:"checked";b:1;s:5:"image";s:0:"";s:5:"label";s:4:"None";s:5:"value";s:1:"0";}i:1;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:8:"1 (Free)";s:5:"value";s:1:"0";}i:2;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:5:"2 - 5";s:5:"value";s:1:"6";}i:3;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:2:"5+";s:5:"value";s:2:"10";}}s:4:"name";s:6:"emails";s:5:"email";s:13:"Total emails:";s:5:"label";s:24:"Total of email addresses";s:11:"description";s:50:"How many email addresses you need for your domain?";s:10:"validation";s:5:"empty";s:7:"display";s:10:"horizontal";s:4:"icon";s:13:"paper-plane-o";s:17:"conditional_items";a:1:{i:0;a:7:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";s:10:"and_method";s:0:"";s:9:"field_and";s:6:"emails";s:9:"logic_and";s:0:"";s:9:"value_and";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"2/3";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:10:{s:4:"math";s:8:"{emails}";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:4:"name";s:11:"total_email";s:5:"email";s:12:"Email total:";s:5:"label";s:2:" ";s:11:"description";s:2:" ";s:5:"align";s:5:"right";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/3";}}i:2;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:11:"padding_top";s:1:"0";}}}}i:1;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:8:"quantity";s:5:"group";s:13:"form_elements";s:4:"data";a:9:{s:4:"name";s:7:"domains";s:5:"email";s:7:"Domains";s:5:"label";s:21:"Total of domain names";s:11:"description";s:49:"Select how many domain names you want to register";s:5:"value";s:1:"0";s:13:"icon_position";s:7:"outside";s:10:"icon_align";s:4:"left";s:4:"icon";s:4:"user";s:17:"conditional_items";a:1:{i:0;a:7:{s:5:"field";s:6:"emails";s:5:"logic";s:0:"";s:5:"value";s:0:"";s:10:"and_method";s:0:"";s:9:"field_and";s:6:"emails";s:9:"logic_and";s:0:"";s:9:"value_and";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"2/3";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:10:{s:4:"name";s:13:"total_domains";s:4:"math";s:13:"{domains}*1.8";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:5:"email";s:12:"Email total:";s:5:"label";s:2:" ";s:11:"description";s:2:" ";s:5:"align";s:5:"right";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:7:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";s:10:"and_method";s:0:"";s:9:"field_and";s:6:"emails";s:9:"logic_and";s:0:"";s:9:"value_and";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/3";}}i:2;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:11:"padding_top";s:1:"0";}}}}i:2;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:2:{i:0;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:8:"checkbox";s:5:"group";s:13:"form_elements";s:4:"data";a:8:{s:14:"checkbox_items";a:3:{i:0;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:13:"Malware scans";s:5:"value";s:1:"0";}i:1;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:17:"Daily Backup ($3)";s:5:"value";s:1:"3";}i:2;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:20:"Montly updates ($10)";s:5:"value";s:2:"10";}}s:4:"name";s:10:"protection";s:5:"email";s:11:"Protection:";s:5:"label";s:39:"Website anti-virus, backups and updates";s:11:"description";s:36:"Select all the protections  you want";s:7:"display";s:10:"horizontal";s:4:"icon";s:3:"bug";s:17:"conditional_items";a:1:{i:0;a:7:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";s:10:"and_method";s:0:"";s:9:"field_and";s:6:"emails";s:9:"logic_and";s:0:"";s:9:"value_and";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"3/4";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:10:{s:4:"math";s:12:"{protection}";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:4:"name";s:16:"total_protection";s:5:"email";s:17:"Protection total:";s:5:"label";s:2:" ";s:11:"description";s:2:" ";s:5:"align";s:5:"right";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/4";}}}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:11:"padding_top";s:1:"0";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:6:"slider";s:5:"group";s:13:"form_elements";s:4:"data";a:10:{s:4:"name";s:5:"scans";s:5:"email";s:8:"Storage:";s:5:"label";s:39:"Select how many scans you want per week";s:11:"description";s:44:"How many Malware scans do you want per week?";s:5:"value";s:1:"1";s:6:"format";s:9:" scan p/w";s:8:"decimals";s:1:"0";s:9:"minnumber";s:1:"1";s:9:"maxnumber";s:2:"50";s:4:"icon";s:8:"database";}}}s:4:"data";a:2:{s:4:"size";s:3:"2/3";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}i:2;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:10:{s:4:"math";s:9:"{scans}*5";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:4:"name";s:11:"total_scans";s:5:"email";s:12:"Scans total:";s:5:"label";s:2:" ";s:11:"description";s:2:" ";s:5:"align";s:5:"right";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}}s:4:"data";a:2:{s:4:"size";s:3:"1/3";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}}s:4:"data";a:2:{s:18:"conditional_action";s:4:"show";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:10:"protection";s:5:"logic";s:8:"contains";s:5:"value";s:1:"0";}}}}i:2;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:11:"padding_top";s:1:"0";}}}}i:3;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:6:"slider";s:5:"group";s:13:"form_elements";s:4:"data";a:9:{s:4:"name";s:7:"storage";s:5:"email";s:8:"Storage:";s:5:"label";s:25:"Select your total storage";s:11:"description";s:51:"How much storage would you need on your new server?";s:5:"value";s:2:"20";s:6:"format";s:3:" GB";s:18:"thousand_separator";s:1:",";s:9:"minnumber";s:2:"10";s:4:"icon";s:8:"database";}}}s:4:"data";a:1:{s:4:"size";s:3:"2/3";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:10:{s:4:"math";s:13:"{storage}*1.5";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:4:"name";s:13:"total_storage";s:5:"email";s:14:"Storage total:";s:5:"label";s:2:" ";s:11:"description";s:2:" ";s:5:"align";s:5:"right";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/3";}}i:2;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:11:"padding_top";s:1:"0";}}}}i:4;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:3:{i:0;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:8:"checkbox";s:5:"group";s:13:"form_elements";s:4:"data";a:8:{s:14:"checkbox_items";a:2:{i:0;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:17:"Off-site SEO ($6)";s:5:"value";s:1:"6";}i:1;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:17:"On-site SEO ($10)";s:5:"value";s:2:"10";}}s:4:"name";s:3:"seo";s:5:"email";s:4:"SEO:";s:5:"label";s:38:"Optimise my website for search engines";s:11:"description";s:62:"Select if you would like Off-site and/or On-site optimisation:";s:7:"display";s:10:"horizontal";s:4:"icon";s:10:"tachometer";s:17:"conditional_items";a:1:{i:0;a:7:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";s:10:"and_method";s:0:"";s:9:"field_and";s:6:"emails";s:9:"logic_and";s:0:"";s:9:"value_and";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"3/4";}}i:1;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:10:{s:4:"math";s:5:"{seo}";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:4:"name";s:9:"total_seo";s:5:"email";s:10:"SEO total:";s:5:"label";s:2:" ";s:11:"description";s:2:" ";s:5:"align";s:5:"right";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}}s:4:"data";a:1:{s:4:"size";s:3:"1/4";}}i:2;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:1:{s:11:"padding_top";s:1:"0";}}}}i:5;a:3:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:7:{i:0;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:11:{s:4:"name";s:8:"subtotal";s:4:"math";s:90:"{total_email}+{total_domains}+{total_protection}+{total_scans}+{total_storage}+{total_seo}";s:12:"amount_label";s:9:"Subtotal:";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:5:"email";s:9:"Subtotal:";s:5:"align";s:5:"right";s:12:"amount_width";s:3:"100";s:6:"margin";s:9:"no_margin";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:7:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";s:10:"and_method";s:0:"";s:9:"field_and";s:6:"emails";s:9:"logic_and";s:0:"";s:9:"value_and";s:0:"";}}}}i:1;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:11:{s:4:"name";s:3:"vat";s:4:"math";s:19:"({subtotal}/100)*21";s:12:"amount_label";s:10:"VAT (21%):";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:5:"email";s:4:"VAT:";s:5:"align";s:5:"right";s:12:"amount_width";s:3:"100";s:6:"margin";s:9:"no_margin";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:3:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";}}}}i:2;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";s:0:"";s:4:"data";a:1:{s:4:"size";s:3:"3/4";}}i:3;a:4:{s:3:"tag";s:6:"column";s:5:"group";s:15:"layout_elements";s:5:"inner";a:1:{i:0;a:3:{s:3:"tag";s:7:"divider";s:5:"group";s:13:"html_elements";s:4:"data";a:2:{s:11:"padding_top";s:2:"10";s:14:"padding_bottom";s:2:"10";}}}s:4:"data";a:1:{s:4:"size";s:3:"1/4";}}i:4;a:3:{s:3:"tag";s:10:"calculator";s:5:"group";s:13:"form_elements";s:4:"data";a:12:{s:4:"name";s:5:"total";s:4:"math";s:16:"{subtotal}+{vat}";s:12:"amount_label";s:6:"Total:";s:8:"currency";s:1:"$";s:18:"thousand_separator";s:1:",";s:11:"email_float";s:4:"true";s:5:"email";s:6:"Total:";s:5:"align";s:5:"right";s:12:"amount_width";s:3:"100";s:6:"margin";s:9:"no_margin";s:13:"icon_position";s:6:"inside";s:17:"conditional_items";a:1:{i:0;a:7:{s:5:"field";s:6:"emails";s:5:"logic";s:8:"contains";s:5:"value";s:0:"";s:10:"and_method";s:0:"";s:9:"field_and";s:6:"emails";s:9:"logic_and";s:0:"";s:9:"value_and";s:0:"";}}}}i:5;a:2:{s:3:"tag";s:6:"spacer";s:5:"group";s:13:"html_elements";}i:6;a:3:{s:3:"tag";s:6:"button";s:5:"group";s:13:"form_elements";s:4:"data";a:6:{s:4:"name";s:27:"Setup my WordPress website!";s:5:"color";s:7:"#f26c68";s:11:"color_hover";s:7:"#444444";s:4:"font";s:7:"#ffffff";s:10:"font_hover";s:7:"#ffffff";s:4:"type";s:2:"2d";}}}}}}',
            'date' => '2018-04-25',
        ),


        array(
            'date' => '2018-03-08',
            'title' => 'GDPR compliance - Conditionally save Entry',
            'description' => 'This form will only save contact entry when user explicitly agrees to saving their personal data.',
            'requirements' => '',
            'live_preview' => '',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","icon":"envelope-o"}},{"tag":"checkbox","group":"form_elements","data":{"name":"option","email":"Option:","checkbox_items":[{"checked":false,"image":"","label":"I agree that my personal data will be saved","value":"true"}],"icon":"check-square-o"}}]',
            'settings' => '{"send":"yes","header_to":"{option_admin_email}","header_from_type":"default","header_subject":"New question","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","header_content_type":"html","header_charset":"UTF-8","email_template":"default_email_template","save_contact_entry":"yes","conditionally_save_entry":"true","conditionally_save_entry_check_1":"{option}","conditionally_save_entry_check_3":"true","conditionally_save_entry_check":"{option},==,true","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_duration":"500","form_hide_after_submitting":"true","theme_field_size":"medium","theme_hide_icons":"yes","theme_center_form":"true","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_tags_bg":"#4EB1B6","theme_ui_tags_font":"#ffffff","theme_ui_tags_remove":"#2e8a90","theme_ui_tags_remove_hover":"#246569","theme_ui_tags_list_bg_hover":"#fdecde","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_multipart_progress_bar":"true","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_multipart_steps":"true","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FF9A9A","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":"12","font_label_size":"16","font_description_size":"14","font_global_family":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","frontend_posting_action":"none","register_login_action":"none"}',
            'import' => 'a:3:{s:5:"title";s:29:"Save entry data conditionally";s:8:"settings";a:119:{s:4:"send";s:3:"yes";s:9:"header_to";s:20:"{option_admin_email}";s:16:"header_from_type";s:7:"default";s:14:"header_subject";s:12:"New question";s:15:"email_body_open";s:57:"The following information has been send by the submitter:";s:10:"email_body";s:44:"<table cellpadding="5">{loop_fields}</table>";s:16:"email_body_close";s:31:"Best regards, {option_blogname}";s:10:"email_loop";s:78:"<tr><th valign="top" align="right">{loop_label}</th><td>{loop_value}</td></tr>";s:16:"email_body_nl2br";s:4:"true";s:7:"confirm";s:3:"yes";s:10:"confirm_to";s:7:"{email}";s:17:"confirm_from_type";s:7:"default";s:15:"confirm_subject";s:10:"Thank you!";s:17:"confirm_body_open";s:40:"Dear user,

Thank you for contacting us!";s:12:"confirm_body";s:44:"<table cellpadding="5">{loop_fields}</table>";s:18:"confirm_body_close";s:63:"We will reply within 48 hours.

Best Regards, {option_blogname}";s:18:"confirm_body_nl2br";s:4:"true";s:19:"header_content_type";s:4:"html";s:14:"header_charset";s:5:"UTF-8";s:14:"email_template";s:22:"default_email_template";s:18:"save_contact_entry";s:3:"yes";s:24:"conditionally_save_entry";s:4:"true";s:32:"conditionally_save_entry_check_1";s:8:"{option}";s:32:"conditionally_save_entry_check_3";s:4:"true";s:30:"conditionally_save_entry_check";s:16:"{option},==,true";s:20:"form_show_thanks_msg";s:4:"true";s:17:"form_thanks_title";s:10:"Thank you!";s:23:"form_thanks_description";s:30:"We will reply within 24 hours.";s:12:"form_preload";s:1:"1";s:13:"form_duration";s:3:"500";s:26:"form_hide_after_submitting";s:4:"true";s:16:"theme_field_size";s:6:"medium";s:16:"theme_hide_icons";s:3:"yes";s:17:"theme_center_form";s:4:"true";s:26:"theme_ui_loading_icon_font";s:7:"#c5c5c5";s:17:"theme_field_label";s:7:"#444444";s:23:"theme_field_description";s:7:"#8e8e8e";s:24:"theme_ui_checkbox_border";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_inner";s:7:"#4EB1B6";s:23:"theme_ui_checkbox_label";s:7:"#444444";s:20:"theme_ui_quantity_bg";s:7:"#4EB1B6";s:22:"theme_ui_quantity_font";s:7:"#ffffff";s:26:"theme_ui_quantity_bg_hover";s:7:"#7ed0d4";s:28:"theme_ui_quantity_font_hover";s:7:"#ffffff";s:18:"theme_ui_toggle_bg";s:7:"#4EB1B6";s:20:"theme_ui_toggle_font";s:7:"#ffffff";s:27:"theme_ui_toggle_disabled_bg";s:7:"#e4e4e4";s:29:"theme_ui_toggle_disabled_font";s:7:"#9c9c9c";s:20:"theme_ui_keywords_bg";s:7:"#4EB1B6";s:22:"theme_ui_keywords_font";s:7:"#ffffff";s:22:"theme_ui_keywords_icon";s:7:"#2e8a90";s:28:"theme_ui_keywords_icon_hover";s:7:"#246569";s:16:"theme_ui_tags_bg";s:7:"#4EB1B6";s:18:"theme_ui_tags_font";s:7:"#ffffff";s:20:"theme_ui_tags_remove";s:7:"#2e8a90";s:26:"theme_ui_tags_remove_hover";s:7:"#246569";s:27:"theme_ui_tags_list_bg_hover";s:7:"#fdecde";s:23:"theme_ui_slider_dragger";s:7:"#4EB1B6";s:21:"theme_ui_slider_track";s:7:"#CDCDCD";s:22:"theme_field_colors_top";s:7:"#ffffff";s:25:"theme_field_colors_bottom";s:7:"#ffffff";s:25:"theme_field_colors_border";s:7:"#cdcdcd";s:23:"theme_field_colors_font";s:7:"#444444";s:30:"theme_field_colors_placeholder";s:7:"#444444";s:28:"theme_field_colors_top_focus";s:7:"#ffffff";s:31:"theme_field_colors_bottom_focus";s:7:"#ffffff";s:31:"theme_field_colors_border_focus";s:7:"#cdcdcd";s:29:"theme_field_colors_font_focus";s:7:"#444444";s:36:"theme_field_colors_placeholder_focus";s:7:"#444444";s:18:"theme_rating_color";s:7:"#cdcdcd";s:15:"theme_rating_bg";s:7:"#ffffff";s:19:"theme_rating_border";s:7:"#cdcdcd";s:24:"theme_rating_color_hover";s:7:"#f7f188";s:21:"theme_rating_bg_hover";s:7:"#ffffff";s:25:"theme_rating_color_active";s:7:"#f7ea00";s:22:"theme_rating_bg_active";s:7:"#ffffff";s:28:"theme_multipart_progress_bar";s:4:"true";s:32:"theme_progress_bar_primary_color";s:7:"#87CC83";s:34:"theme_progress_bar_secondary_color";s:7:"#E2E2E2";s:31:"theme_progress_bar_border_color";s:7:"#CECECE";s:21:"theme_multipart_steps";s:4:"true";s:33:"theme_progress_step_primary_color";s:7:"#CECECE";s:35:"theme_progress_step_secondary_color";s:7:"#E2E2E2";s:32:"theme_progress_step_border_color";s:7:"#CECECE";s:30:"theme_progress_step_font_color";s:7:"#FFFFFF";s:40:"theme_progress_step_primary_color_active";s:7:"#87CC83";s:42:"theme_progress_step_secondary_color_active";s:7:"#E2E2E2";s:39:"theme_progress_step_border_color_active";s:7:"#CECECE";s:37:"theme_progress_step_font_color_active";s:7:"#FFFFFF";s:16:"theme_error_font";s:7:"#f2322b";s:26:"theme_error_msg_font_color";s:7:"#D08080";s:28:"theme_error_msg_border_color";s:7:"#FFCBCB";s:24:"theme_error_msg_bg_color";s:7:"#FFEBEB";s:26:"theme_error_msg_icon_color";s:7:"#FF9A9A";s:28:"theme_success_msg_font_color";s:7:"#5E7F62";s:30:"theme_success_msg_border_color";s:7:"#90C397";s:26:"theme_success_msg_bg_color";s:7:"#C5FFCD";s:28:"theme_success_msg_icon_color";s:7:"#90C397";s:24:"theme_success_msg_margin";s:16:"0px 0px 30px 0px";s:15:"theme_max_width";s:1:"0";s:17:"theme_form_margin";s:15:"0px 0px 0px 0px";s:16:"font_global_size";s:2:"12";s:15:"font_label_size";s:2:"16";s:21:"font_description_size";s:2:"14";s:18:"font_global_family";s:0:"";s:11:"form_button";s:6:"Submit";s:19:"form_button_loading";s:10:"Loading...";s:18:"theme_button_color";s:7:"#f26c68";s:24:"theme_button_color_hover";s:7:"#444444";s:17:"theme_button_font";s:7:"#ffffff";s:23:"theme_button_font_hover";s:7:"#ffffff";s:18:"form_button_radius";s:6:"square";s:16:"form_button_type";s:4:"flat";s:16:"form_button_size";s:6:"medium";s:17:"form_button_align";s:4:"left";s:17:"form_button_width";s:4:"auto";s:23:"form_button_icon_option";s:4:"none";s:23:"frontend_posting_action";s:4:"none";s:21:"register_login_action";s:4:"none";}s:8:"elements";a:2:{i:0;a:3:{s:3:"tag";s:4:"text";s:5:"group";s:13:"form_elements";s:4:"data";a:5:{s:4:"name";s:5:"email";s:5:"email";s:14:"Email address:";s:11:"placeholder";s:18:"Your Email Address";s:10:"validation";s:5:"email";s:4:"icon";s:10:"envelope-o";}}i:1;a:3:{s:3:"tag";s:8:"checkbox";s:5:"group";s:13:"form_elements";s:4:"data";a:4:{s:4:"name";s:6:"option";s:5:"email";s:7:"Option:";s:14:"checkbox_items";a:1:{i:0;a:4:{s:7:"checked";b:0;s:5:"image";s:0:"";s:5:"label";s:43:"I agree that my personal data will be saved";s:5:"value";s:4:"true";}}s:4:"icon";s:14:"check-square-o";}}}}'

        ),
        
        array(
            'date' => '2017-12-12',
            'title' => 'PayPal – Cart Checkout',
            'description' => 'PayPal cart checkout example for multiple product(s) checkout',
            'requirements' => 'paypal',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/paypal-cart-checkout/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","error":"Required","icon":"envelope-o"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"dropdown","group":"form_elements","data":{"name":"product","email":"Selected Product:","dropdown_items":[{"checked":false,"label":"Towel","value":"1.5"},{"checked":false,"label":"Football","value":"5.72"},{"checked":false,"label":"Roses","value":"2.23"}],"placeholder":"- select a product -","validation":"empty","error":"Required","exclude":"2","exclude_entry":"true","error_position":"bottom-left","icon":"toggle-down"}},{"tag":"hidden","group":"form_elements","data":{"name":"product_label","email":"Product:","conditional_variable_action":"enabled","conditional_items":[{"field":"product","logic":"not_equal","value":"","and_method":"","field_and":"email","logic_and":"","value_and":"","new_value":"{product;label}"}]}},{"tag":"hidden","group":"form_elements","data":{"name":"product_price","email":"Price:","exclude":"2","exclude_entry":"true","conditional_variable_action":"enabled","conditional_items":[{"field":"product","logic":"not_equal","value":"","and_method":"","field_and":"email","logic_and":"","value_and":"","new_value":"{product}"}]}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"quantity","group":"form_elements","data":{"name":"quantity","email":"Quantity:","value":"1","minnumber":"1"}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_price","email":"Subtotal:","math":"{quantity}*{product_price}","currency":"$","email_float":"true"}}],"data":{"size":"1/3"}}],"data":{"duplicate":"enabled","duplicate_dynamically":"true"}}]',
            'settings' => '{"send":"no","header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_reply_enabled":"","header_reply":"{option_admin_email}","header_reply_name":"{option_blogname}","header_subject":"This mail was send from yourdomain.com","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_header_reply_enabled":"","confirm_header_reply":"{option_admin_email}","confirm_header_reply_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","admin_attachments":"","confirm_attachments":"","email_template":"default_email_template","save_contact_entry":"yes","contact_entry_custom_status":"","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","save_form_progress":"","update_contact_entry":"","contact_entry_custom_status_update":"","retrieve_last_entry_data":"","retrieve_last_entry_form":"","form_show_thanks_msg":"true","form_thanks_title":"Please wait!","form_thanks_description":"You will now automatically be redirected to PayPal","form_preload":"1","form_duration":"500","form_post_option":"","form_post_url":"","form_post_custom":"","form_post_parameters":"","form_post_timeout":"5","form_post_http_version":"1.0","form_post_debug":"","form_disable_enter":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_ga_tracking":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","form_locker":"","form_locker_limit":"10","form_locker_submission_reset":"0","form_locker_msg":"true","form_locker_msg_title":"Please note:","form_locker_msg_desc":"This form is no longer available","form_locker_hide":"true","form_locker_reset":"","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_center_form":"","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_multipart_progress_bar":"true","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_multipart_steps":"true","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":"12","font_label_size":"16","font_description_size":"14","font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Buy Now","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","paypal_checkout":"true","paypal_mode":"sandbox","paypal_merchant_email":"payments@feeling4design.nl","paypal_currency_code":"USD","paypal_no_shipping":"0","paypal_payment_type":"cart","paypal_item_name":"Roses","paypal_item_amount":"3.56","paypal_item_quantity":"1","paypal_item_weight":"4","paypal_item_number":"123456-1234","paypal_item_discount_amount":"5","paypal_item_discount_rate":"3","paypal_item_discount_num":"","paypal_item_shipping":"6.5","paypal_item_shipping2":"","paypal_subscription_periods":"","paypal_cart_items":"{product_price}|{quantity}|{product_label}","paypal_tax_cart":"","paypal_weight_cart":"","paypal_discount_amount_cart":"","paypal_discount_rate_cart":"","paypal_handling_cart":"","paypal_custom_return_url":"","paypal_return_url":"http:\/\/f4d.nl\/dev\/my-custom-thank-you-page","paypal_cancel_url":"","paypal_advanced_settings":"","paypal_lc":"US","paypal_charset":"UTF-8","paypal_handling":"","paypal_undefined_quantity":"","paypal_weight_unit":"lbs","paypal_invoice":"","paypal_night_phone_a":"","night_phone_b":"","night_phone_c":"","paypal_custom_address":"true","paypal_address_override":"","paypal_first_name":"","paypal_last_name":"","paypal_email":"","paypal_address1":"","paypal_address2":"","paypal_city":"","paypal_state":"","paypal_zip":"","paypal_country":"","paypal_completed_entry_status":"completed","paypal_notify_url":"","paypal_completed_post_status":"publish","paypal_completed_signup_status":"active","register_login_action":"none","register_login_action_skip_register":"","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_send_approve_email":"","register_approve_subject":"Account has been approved","register_approve_email":"Dear {user_login},\n\nYour account has been approved and can now be used!\n\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{user_pass}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login into your account.\n\n\nBest regards,\n\n{option_blogname}","register_approve_generate_pass":"","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","register_login_multisite_enabled":"","register_login_multisite_domain":"{user_email}","register_login_multisite_path":"{user_email}","register_login_multisite_title":"{user_email}","register_login_multisite_id":"1","register_login_multisite_email":"true","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","register_login_not_logged_in_msg":"You must be logged in to submit this form. Click <a href=\"{register_login_url}\">here<\/a> to login!","register_login_update_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","zapier_enable":"","zapier_webhook":"","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2017-10-24","popup_till":"2017-10-24","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
        ),
        array(
            'title' => 'Difference Between 2 Times 24h',
            'description' => 'Calculates the difference in hours and minutes between 2 timepickers on 24 hour basis',
            'requirements' => 'calculator',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/dynamic-fields-with-calculations/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"time","group":"form_elements","data":{"name":"from","email":"From","placeholder":"From","icon":"clock-o"}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"time","group":"form_elements","data":{"name":"till","email":"Till","placeholder":"Till","icon":"clock-o"}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"time","group":"form_elements","data":{"name":"zero","placeholder":"00:00","exclude":"2","exclude_entry":"true","icon":"clock-o"}},{"tag":"calculator","group":"form_elements","data":{"name":"zero_timestamp","math":"{zero}/1000","label":"zero_timestamp","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"zero_timestamp2","math":"{zero}/1000","label":"zero_timestamp","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"from_timestamp","math":"{from}/1000","label":"from_timestamp","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"zero_from_diff","math":"{from_timestamp}-{zero_timestamp}","label":"zero_from_diff","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"till_timestamp","math":"{till}/1000","label":"till_timestamp","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"zero_till_diff","math":"{till_timestamp}-{zero_timestamp}","label":"zero_till_diff","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"from_till_diff","math":"{zero_till_diff}-{zero_from_diff}","label":"from_till_diff","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"from_till_midnight_diff","math":"86400-({zero_from_diff}-{zero_till_diff})","label":"from_till_midnight_diff","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"hidden","group":"form_elements","data":{"name":"final_diff","exclude":"2","exclude_entry":"true","conditional_variable_action":"enabled","conditional_items":[{"field":"from_till_diff","logic":"greater_than_or_equal","value":"0","and_method":"","field_and":"zero","logic_and":"","value_and":"","new_value":"{from_till_diff}"},{"field":"from_till_diff","logic":"less_than","value":"0","and_method":"","field_and":"zero","logic_and":"","value_and":"","new_value":"{from_till_midnight_diff}"}]}},{"tag":"calculator","group":"form_elements","data":{"name":"hour_diff","math":"Math.floor({final_diff}/60/60)","amount_label":"Hours: ","decimals":"0"}},{"tag":"calculator","group":"form_elements","data":{"name":"minute_diff","math":"Math.floor({final_diff}/60) - ({hour_diff}*60)","amount_label":"Minutes: ","decimals":"0"}}],"data":{"invisible":"true"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"html","group":"html_elements","data":{"html":"{hour_diff} hours and {minute_diff} minutes."}},{"tag":"spacer","group":"html_elements"}],"data":{"conditional_action":"show","conditional_items":[{"field":"from","logic":"not_equal","value":"","and_method":"and","field_and":"till","logic_and":"not_equal","value_and":""}]}}]',
            'settings' => '{"send":"yes","header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_reply_enabled":"","header_reply":"{option_admin_email}","header_reply_name":"{option_blogname}","header_subject":"This mail was send from yourdomain.com","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_header_reply_enabled":"","confirm_header_reply":"{option_admin_email}","confirm_header_reply_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","admin_attachments":"","confirm_attachments":"","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"url_facebook_page|url_social_icon|Facebook","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","contact_entry_custom_status":"","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","save_form_progress":"","update_contact_entry":"","contact_entry_custom_status_update":"","retrieve_last_entry_data":"","retrieve_last_entry_form":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_post_option":"","form_post_url":"","form_disable_enter":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","form_locker":"","form_locker_limit":"10","form_locker_msg":"true","form_locker_msg_title":"Please note:","form_locker_msg_desc":"This form is no longer available","form_locker_hide":"true","form_locker_reset":"","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_multipart_progress_bar":"true","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_multipart_steps":"true","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":"12","font_label_size":"16","font_description_size":"14","font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","register_login_action_skip_register":"","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","register_login_multisite_enabled":"","register_login_multisite_domain":"{user_email}","register_login_multisite_path":"{user_email}","register_login_multisite_title":"{user_email}","register_login_multisite_id":"1","register_login_multisite_email":"true","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","register_login_not_logged_in_msg":"You must be logged in to submit this form. Click <a href=\"{register_login_url}\">here<\/a> to login!","register_login_update_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_checkout_fields":"","woocommerce_checkout_fields_skip_empty":"","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active"}',
            'date' => '2017-10-22',
        ),
        array(
            'title' => 'Distance calculator',
            'description' => 'Form to calculate distance between two addresses given by the user',
            'requirements' => 'calculator',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/distance-calculator/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"html","group":"html_elements","data":{"html":"In the below example we have used the Calculator element to demonstrate how flexible Super Forms in a whole is. The form uses Google places API to auto populate the addresses and calculates the difference between the 2 addresses entered by the user. Based on the result a price is being calculated. Of course you can customize the math for this calculation."}},{"tag":"spacer","group":"html_elements"}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"from","email":"From:","label":"From:","placeholder":"From","validation":"empty","error":"Enter from address","enable_distance_calculator":"true","distance_destination":"destination","distance_value":"dis_text","distance_field":"distance","enable_address_auto_complete":"true"}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"destination","email":"Destination:","label":"Destination:","placeholder":"Destination","validation":"empty","error":"Enter your destination","enable_distance_calculator":"true","distance_method":"destination","distance_start":"from","enable_address_auto_complete":"true"}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"distance","email":"Distance:","label":"Distance:","placeholder":"0 km","disabled":"1"}},{"tag":"calculator","group":"form_elements","data":{"name":"costs","email":"Subtotal:","math":"{distance}*15","currency":"$","label":"Costs:"}}],"data":{"size":"1/3"}}]',
            'settings' => '{"send":"no","header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_reply_enabled":"","header_reply":"{option_admin_email}","header_reply_name":"{option_blogname}","header_subject":"New question","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_header_reply_enabled":"","confirm_header_reply":"{option_admin_email}","confirm_header_reply_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","update_contact_entry":"","retrieve_last_entry_data":"","retrieve_last_entry_form":"","form_duration":"500","form_show_thanks_msg":"","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_post_option":"","form_post_url":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"","form_clear_after_submitting":"true","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FF9A9A","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":"12","font_label_size":"16","font_description_size":"14","font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","csv_attachment_enable":"","csv_attachment_name":"super-csv-attachment","csv_attachment_save_as":"admin_email_value","csv_attachment_exclude":"","csv_attachment_delimiter":",","csv_attachment_enclosure":"\"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","password_protect":"","password_protect_password":")w98(S2YZ5Czbb2V#$^@6MII","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_login_multisite_enabled":"","register_login_multisite_domain":"{user_email}","register_login_multisite_path":"{user_email}","register_login_multisite_title":"{user_email}","register_login_multisite_id":"1","register_login_multisite_email":"true","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","register_login_not_logged_in_msg":"You must be logged in to submit this form. Click <a href=\"{register_login_url}\">here<\/a> to login!","register_login_update_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2017-09-06","popup_till":"2017-09-06","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2017-09-06',
        ),
        array(
            'title' => 'Google address autocomplete',
            'description' => 'Form that uses goole places to autopopulate/autocomplete address information when user starts typing, once user selects an address it will fill out the fields that are mapped',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/google-address-autocomplete/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"field_OOBtW","label":"Your address:","placeholder":"type to search...","enable_address_auto_complete":"true","address_api_key":"","enable_address_auto_populate":"true","address_auto_populate_mappings":[{"key":"street_number","field":"street_number","type":""},{"key":"street_name","field":"street_name","type":""},{"key":"street_name_number","field":"city","type":""},{"key":"street_number_name","field":"state","type":""},{"key":"city","field":"zipcode","type":""},{"key":"state","field":"country","type":""},{"key":"postal_code","field":"","type":""},{"key":"country","field":"","type":""},{"key":"municipality","field":"","type":""}],"autocomplete":"true","exclude":"2","exclude_entry":"true"}},{"tag":"divider","group":"html_elements","data":{"color":"#bcbcbc","padding_top":"0"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"street_name","email":"Street name","label":"Street name","placeholder":"Street name","validation":"empty"}}],"data":{"size":"3/5"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"street_number","email":"Street number","label":"Street number","placeholder":"Street number","validation":"empty"}}],"data":{"size":"2/5"}},{"tag":"text","group":"form_elements","data":{"name":"city","email":"City","label":"City","placeholder":"City","validation":"empty"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"state","email":"State","label":"State","placeholder":"State","validation":"empty"}}],"data":{"size":"3/5"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"zipcode","email":"Zip code","label":"Zip code","placeholder":"Zip code","validation":"empty"}}],"data":{"size":"2/5"}},{"tag":"text","group":"form_elements","data":{"name":"country","email":"Country","label":"Country","placeholder":"Country","validation":"empty"}}]',
            'settings' => '{"send":"no","header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_reply_enabled":"","header_reply":"{option_admin_email}","header_reply_name":"{option_blogname}","header_subject":"New question","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_header_reply_enabled":"","confirm_header_reply":"{option_admin_email}","confirm_header_reply_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","admin_attachments":"","confirm_attachments":"","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","contact_entry_custom_status":"","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","save_form_progress":"","update_contact_entry":"","contact_entry_custom_status_update":"","retrieve_last_entry_data":"","retrieve_last_entry_form":"","form_duration":"500","form_show_thanks_msg":"","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_google_places_api":"","form_post_option":"","form_post_url":"","form_disable_enter":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"","form_clear_after_submitting":"true","form_locker":"","form_locker_limit":10,"form_locker_submission_reset":0,"form_locker_msg":"true","form_locker_msg_title":"Please note:","form_locker_msg_desc":"This form is no longer available","form_locker_hide":"true","form_locker_reset":"","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_multipart_progress_bar":"true","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_multipart_steps":"true","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FF9A9A","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":"12","font_label_size":"16","font_description_size":"14","font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_status":"pending|Pending|#808080|#FFFFFF\nprocessing|Processing|#808080|#FFFFFF\non_hold|On hold|#FF7700|#FFFFFF\naccepted|Accepted|#2BC300|#FFFFFF\ncompleted|Completed|#2BC300|#FFFFFF\ncancelled|Cancelled|#E40000|#FFFFFF\ndeclined|Declined|#E40000|#FFFFFF\nrefunded|Refunded|#000000|#FFFFFF","backend_contact_entry_list_form":"true","backend_contact_entry_list_ip":"","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","csv_attachment_enable":"","csv_attachment_name":"super-csv-attachment","csv_attachment_save_as":"admin_email_value","csv_attachment_exclude":"","csv_attachment_delimiter":",","csv_attachment_enclosure":"\"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","password_protect":"","password_protect_password":")QtN#YvQR&2uj%qcJPJInR7K","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","password_protect_show_login_after_submit":"true","password_protect_not_login_hide":"","register_login_action":"none","register_login_action_skip_register":"","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_send_approve_email":"","register_approve_subject":"Account has been approved","register_approve_email":"Dear {user_login},\n\nYour account has been approved and can now be used!\n\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{user_pass}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login into your account.\n\n\nBest regards,\n\n{option_blogname}","register_approve_generate_pass":"","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_login_multisite_enabled":"","register_login_multisite_domain":"{user_email}","register_login_multisite_path":"{user_email}","register_login_multisite_title":"{user_email}","register_login_multisite_id":"1","register_login_multisite_email":"true","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","register_login_not_logged_in_msg":"You must be logged in to submit this form. Click <a href=\"{register_login_url}\">here<\/a> to login!","register_login_update_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_checkout_fields":"","woocommerce_checkout_fields_skip_empty":"","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2017-09-06","popup_till":"2017-09-06","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2017-09-06',
        ),
        array(
            'title' => 'Popup 1',
            'description' => 'Popup 1 template',
            'requirements' => 'popups',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/popup-1-live-preview/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"spacer","group":"html_elements"},{"tag":"heading","group":"html_elements","data":{"title":"ARE YOU READY? GET IT NOW!","heading_color":"#ffffff","heading_size":"24","heading_weight":"900","heading_align":"center","heading_margin":"10px 0px -15px 0px"}},{"tag":"divider","group":"html_elements","data":{"color":"#50dcb4","thickness":"5","border_style":"solid","width":"50","align":"center","padding_top":"0","padding_bottom":"0"}},{"tag":"heading","group":"html_elements","data":{"desc":"Increase more than 500% of Email Subscribers!","heading_color":"#ffffff","heading_size":"24","heading_weight":"900","heading_align":"center","desc_color":"#ffffff","desc_size":"16","desc_align":"center","desc_line_height":"30","desc_margin":"10px 0px 50px 0px"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Enter your name...","validation":"empty","error":"Please enter your name","icon_position":"inside"}},{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Enter your e-mail...","validation":"email","error":"Invalid email address","icon_position":"inside","icon":"envelope"}},{"tag":"button","group":"form_elements","data":{"name":" Subscribe now!","custom_colors":"custom","color":"#2b2b2b","color_hover":"#0f0f0f","font":"#ffffff","font_hover":"#ffffff","custom_advanced":"custom","radius":"full-rounded","align":"center","custom_icon":"custom","icon_option":"left","icon":"check-square-o"}}],"data":{"bg_color":"#22ffc0","bg_opacity":"0.7","enable_padding":"true","padding":"20px 50px 20px 50px"}},{"tag":"heading","group":"html_elements","data":{"desc":"<i class=\"fas fa-lock\"></i> Your Information will never be shared with any third party.","desc_color":"#ffffff","desc_align":"center","desc_margin":"10px 0px -12px 0px"}}],"data":{"bg_color":"#000000","bg_opacity":"0.4"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"New subscriber!","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"New subscriber:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for subscribing!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"","form_clear_after_submitting":"true","theme_style":"super-full-rounded","theme_hide_icons":"no","theme_rtl":"","theme_icon_color":"#4d4d4d","theme_icon_color_focus":"#4d4d4d","theme_icon_bg":"","theme_icon_bg_focus":"","theme_icon_border":"","theme_icon_border_focus":"","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#ffffff","theme_field_colors_font":"#4d4d4d","theme_field_colors_placeholder":"#4d4d4d","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#ffffff","theme_field_colors_font_focus":"#4d4d4d","theme_field_colors_placeholder_focus":"#4d4d4d","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#000000","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#c5ffcd","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 0px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"https:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"true","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"5","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-09-25","popup_till":"2016-09-25","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#ffffff","popup_close_btn_bg_color":"#50dcb4","popup_close_btn_label":"","popup_close_btn_label_color":"#ffffff","popup_close_btn_label_bg_color":"","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"-15","popup_close_btn_right":"-15","popup_close_btn_padding":"","popup_close_btn_radius":"100","popup_enable_padding":"true","popup_padding":"0px 0px 0px 0px","popup_expire_trigger":"","popup_expire":"15","popup_width":"550","popup_background_color":"#fe723e","popup_overlay_color":"#0f0f0f","popup_overlay_opacity":"0.5","popup_background_image":"31366","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"from_top","popup_slide_duration":"1000","popup_fade_duration":"1000","popup_fade_out_duration":"500","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"10","popup_border_color":"#a7c1c5","popup_border_radius_top_left":"0","popup_border_radius_top_right":"0","popup_border_radius_bottom_left":"0","popup_border_radius_bottom_right":"0","popup_enable_shadows":"true","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-12-18',
        ),
        array(
            'title' => 'Popup 2',
            'description' => 'Popup 2 template',
            'requirements' => 'popups',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/popup-2-live-preview/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"<i class=\"fas fa-lock\" style=\"font-size:40px;\"></i>","heading_color":"#000000","heading_size":"34","heading_align":"center","desc_color":"#ffffff","desc_size":"20"}},{"tag":"heading","group":"html_elements","data":{"title":"Age Verification","heading_color":"#000000","heading_size":"34","heading_align":"center","desc_color":"#ffffff","desc_size":"20"}},{"tag":"divider","group":"html_elements","data":{"width":"50","align":"center","padding_top":"0"}},{"tag":"heading","group":"html_elements","data":{"desc":"You must be 18 or over to access this website. If you are under 18 - you have to leave","heading_color":"#000000","heading_size":"34","heading_align":"center","desc_color":"#000000","desc_size":"16","desc_align":"center"}},{"tag":"button","group":"form_elements","data":{"name":"Yes, I\'m over 18 ","custom_colors":"custom","color":"#02be69","color_hover":"#20c985","font":"#ffffff","font_hover":"#ffffff","custom_advanced":"custom","width":"fullwidth","class":"super-popup-close","custom_icon":"custom","icon_option":"right","icon":"check"}},{"tag":"heading","group":"html_elements","data":{"desc":"<strong>OR</strong>","heading_color":"#000000","heading_size":"34","heading_align":"center","desc_color":"#000000","desc_size":"16","desc_align":"center","desc_margin":"20px 0px -5px 0px"}},{"tag":"button","group":"form_elements","data":{"name":"No, take me out of here ","custom_colors":"custom","color":"#ff3649","color_hover":"#ff6070","font":"#ffffff","font_hover":"#ffffff","custom_advanced":"custom","width":"fullwidth","class":"super-popup-close","custom_icon":"custom","icon_option":"right","icon":"times"}}],"data":{"size":"1/2","bg_color":"#eaeaea","enable_padding":"true","padding":"40px 25px 40px 25px","margin":"no_margin"}}],"data":{"enable_padding":"true"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#ffffff","theme_field_colors_font":"#ffffff","theme_field_colors_placeholder":"#a3a3a3","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#ffffff","theme_field_colors_font_focus":"#ffffff","theme_field_colors_placeholder_focus":"#a3a3a3","theme_field_transparent":"true","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#ffffff","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"https:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"true","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"5","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-09-25","popup_till":"2016-09-25","popup_disable_closing":"true","popup_close_btn":"","popup_close_btn_icon_color":"#ffffff","popup_close_btn_bg_color":"","popup_close_btn_label":"Close","popup_close_btn_label_color":"#ffffff","popup_close_btn_label_bg_color":"","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"1","popup_close_btn_border_color":"#ffffff","popup_close_btn_top":"5","popup_close_btn_right":"5","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"true","popup_padding":"0px 0px 0px 0px","popup_expire_trigger":"","popup_expire":"0","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#0f0f0f","popup_overlay_opacity":"0.5","popup_background_image":"32600","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"from_top","popup_slide_duration":"1000","popup_fade_duration":"1000","popup_fade_out_duration":"500","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"2","popup_border_color":"#00e1ff","popup_border_radius_top_left":"18","popup_border_radius_top_right":"9","popup_border_radius_bottom_left":"2","popup_border_radius_bottom_right":"92","popup_enable_shadows":"true","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-12-18',
        ),
        array(
            'title' => 'Popup 3',
            'description' => 'Popup 3 template',
            'requirements' => 'popups',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/popup-3-live-preview/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"SUBSCRIBE NOW!","desc":"Receive weekly recommendations right in your inbox.","heading_color":"#2b4450","heading_size":"46","heading_weight":"400","heading_align":"center","heading_line_height":"54","desc_color":"#497285","desc_size":"15","desc_align":"center","desc_line_height":"26"}}],"data":{"enable_padding":"true","padding":"50px 0px 20px 0px"}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/5"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Your name...","validation":"empty","error":"Please enter your name"}},{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","error":"Invalid email address","icon":"envelope-o"}},{"tag":"button","group":"form_elements","data":{"name":" SUBMIT","custom_colors":"custom","color":"#f78536","color_hover":"#dc7731","font":"#ffffff","font_hover":"#ffffff","custom_advanced":"custom","radius":"rounded","size":"large","width":"fullwidth","custom_icon":"custom","icon_option":"left","icon":"check"}}],"data":{"size":"3/5","enable_padding":"true","padding":"0px 0px 50px 0px"}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/5"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"New subscriber!","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"New subscriber:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","theme_style":"super-style-one","theme_hide_icons":"no","theme_rtl":"","theme_icon_color":"#4a7385","theme_icon_color_focus":"#4a7385","theme_icon_bg":"#deeaec","theme_icon_bg_focus":"#deeaec","theme_icon_border":"#deeaec","theme_icon_border_focus":"#deeaec","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#deeaec","theme_field_colors_bottom":"#deeaec","theme_field_colors_border":"#4a7385","theme_field_colors_font":"#4a7385","theme_field_colors_placeholder":"#4a7385","theme_field_colors_top_focus":"#deeaec","theme_field_colors_bottom_focus":"#deeaec","theme_field_colors_border_focus":"#4a7385","theme_field_colors_font_focus":"#4a7385","theme_field_colors_placeholder_focus":"#4a7385","theme_field_transparent":"true","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f78536","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"20px 0px 0px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"https:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"true","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"5","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-09-25","popup_till":"2016-09-25","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#497285","popup_close_btn_bg_color":"","popup_close_btn_label":"","popup_close_btn_label_color":"#ffffff","popup_close_btn_label_bg_color":"","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"18","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"5","popup_close_btn_right":"5","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"15","popup_width":"700","popup_background_color":"#deeaec","popup_overlay_color":"#0f0f0f","popup_overlay_opacity":"0.5","popup_background_image":"","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"from_top","popup_slide_duration":"1000","popup_fade_duration":"1000","popup_fade_out_duration":"500","popup_sticky":"default","popup_enable_borders":"true","popup_border_size":"10","popup_border_color":"#a7c1c5","popup_border_radius_top_left":"0","popup_border_radius_top_right":"0","popup_border_radius_bottom_left":"0","popup_border_radius_bottom_right":"0","popup_enable_shadows":"true","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-12-18',
        ),
        array(
            'title' => 'Popup 4',
            'description' => 'Popup 4 template',
            'requirements' => 'popups',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/popup-4-live-preview/',
            'elements' => '[{"tag":"heading","group":"html_elements","data":{"title":"CONTACT US","heading_color":"#ffffff","heading_size":"26"}},{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Enter your name...","validation":"empty","error":"Please enter your name","icon_position":"inside"}},{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Enter your e-mail...","validation":"email","error":"Invalid email address","icon_position":"inside","icon":"envelope"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Enter your message...","validation":"empty","error":"You forgot to ask us something","icon_position":"inside"}},{"tag":"button","group":"form_elements","data":{"name":"SEND MESSAGE","custom_colors":"custom","color":"#a73d5b","color_hover":"#8f344e","font":"#ffffff","font_hover":"#ffffff","custom_advanced":"custom","radius":"rounded","type":"3d","size":"big","width":"fullwidth"}},{"tag":"spacer","group":"html_elements","data":{"height":"10"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"","form_clear_after_submitting":"true","theme_style":"super-default-rounded","theme_hide_icons":"no","theme_rtl":"","theme_icon_color":"#8b667b","theme_icon_color_focus":"#8b667b","theme_icon_bg":"","theme_icon_bg_focus":"","theme_icon_border":"","theme_icon_border_focus":"","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#f9f5ef","theme_field_colors_bottom":"#f9f5ef","theme_field_colors_border":"#f9f5ef","theme_field_colors_font":"#8b667b","theme_field_colors_placeholder":"#8b667b","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#ffffff","theme_field_colors_font_focus":"#8b667b","theme_field_colors_placeholder_focus":"#8b667b","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#891f3d","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"15px 0px 15px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"https:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"true","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"5","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-09-25","popup_till":"2016-09-25","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#ffffff","popup_close_btn_bg_color":"","popup_close_btn_label":"","popup_close_btn_label_color":"#ffffff","popup_close_btn_label_bg_color":"","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"2","popup_close_btn_right":"2","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"15","popup_width":"350","popup_background_color":"#fe723e","popup_overlay_color":"#0f0f0f","popup_overlay_opacity":"0.5","popup_background_image":"","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"from_top","popup_slide_duration":"1000","popup_fade_duration":"1000","popup_fade_out_duration":"500","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"10","popup_border_color":"#a7c1c5","popup_border_radius_top_left":"0","popup_border_radius_top_right":"0","popup_border_radius_bottom_left":"0","popup_border_radius_bottom_right":"0","popup_enable_shadows":"true","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-12-18',
        ),
        array(
            'title' => 'Popup 6',
            'description' => 'Popup 6 template',
            'requirements' => 'popups',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/popup-6-live-preview/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"image","group":"html_elements","data":{"image":"32608","width":"170","height":"140","alignment":"left"}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"Privacy Policy on Cookies Usage","desc":"We use cookies to help identify your computer so we can tailor your user experience, track shopping basket contents and remember where you are in the order process.","heading_color":"#ffffff","heading_size":"20","heading_weight":"400","heading_line_height":"36","desc_color":"#ffffff","desc_size":"14"}},{"tag":"button","group":"form_elements","data":{"name":"ACCEPT ","custom_colors":"custom","color":"#71d159","color_hover":"#7de064","font":"#ffffff","font_hover":"#ffffff","custom_advanced":"custom","radius":"rounded","align":"right","class":"super-popup-close"}}],"data":{"size":"2/3"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#ffffff","theme_field_colors_font":"#ffffff","theme_field_colors_placeholder":"#a3a3a3","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#ffffff","theme_field_colors_font_focus":"#ffffff","theme_field_colors_placeholder_focus":"#a3a3a3","theme_field_transparent":"true","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#ffffff","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"https:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"true","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"5","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-09-25","popup_till":"2016-09-25","popup_disable_closing":"true","popup_close_btn":"","popup_close_btn_icon_color":"#ffffff","popup_close_btn_bg_color":"","popup_close_btn_label":"Close","popup_close_btn_label_color":"#ffffff","popup_close_btn_label_bg_color":"","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"1","popup_close_btn_border_color":"#ffffff","popup_close_btn_top":"5","popup_close_btn_right":"5","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"close","popup_expire":"15","popup_width":"700","popup_background_color":"#313131","popup_overlay_color":"#0f0f0f","popup_overlay_opacity":"0.5","popup_background_image":"","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"from_top","popup_slide_duration":"1000","popup_fade_duration":"1000","popup_fade_out_duration":"500","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"2","popup_border_color":"#00e1ff","popup_border_radius_top_left":"18","popup_border_radius_top_right":"9","popup_border_radius_bottom_left":"2","popup_border_radius_bottom_right":"92","popup_enable_shadows":"true","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-12-18',
        ),
        array(
            'title' => 'Popup 7',
            'description' => 'Popup 7 template',
            'requirements' => 'popups',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/popup-7-live-preview/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"image","group":"html_elements","data":{"image":"32610","width":"0","height":"0","alignment":"right"}}],"data":{"position":"absolute","positioning":"bottom_right","positioning_right":"-55px","positioning_bottom":"-60px","hide_on_mobile_window":"true"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"image","group":"html_elements","data":{"image":"32611","alignment":"left"}}],"data":{"size":"1/3","resize_disabled_mobile":"true","force_responsiveness_mobile_window":"true"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"Subscribe NOW! Get the latest news from Super Forms","desc":"The most flexible & powerful popup system for WordPress on the market. <strong style=\"font-size:16px;\">Get it right now!</strong>","heading_color":"#ffffff","heading_size":"25","heading_weight":"900","desc_color":"#afafaf","desc_size":"14"}}],"data":{"size":"2/3","resize_disabled_mobile":"true","force_responsiveness_mobile_window":"true"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","icon_position":"inside","icon":"envelope-o"}},{"tag":"button","group":"form_elements","data":{"name":"Subscribe Now!","custom_colors":"custom","color":"#fecb00","color_hover":"#efb300","font":"#000000","font_hover":"#000000","custom_advanced":"custom","radius":"full-rounded","align":"right"}},{"tag":"spacer","group":"html_elements","data":{"height":"25"}},{"tag":"heading","group":"html_elements","data":{"desc":"<i class=\"fas fa-lock\" style=\"color: white;font-size: 16px;padding-right: 10px;\"></i> Your Information will never be shared with any third party","desc_color":"#afafaf","desc_size":"14"}}],"data":{"size":"3/4","resize_disabled_mobile":"true","force_responsiveness_mobile_window":"true"}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/4","resize_disabled_mobile":"true"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"New subscriber!","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"New subscriber:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","theme_style":"super-full-rounded","theme_hide_icons":"no","theme_rtl":"","theme_icon_color":"#4d4d4d","theme_icon_color_focus":"#4d4d4d","theme_icon_bg":"","theme_icon_bg_focus":"","theme_icon_border":"","theme_icon_border_focus":"","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#ffffff","theme_field_colors_font":"#4d4d4d","theme_field_colors_placeholder":"#4d4d4d","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#ffffff","theme_field_colors_font_focus":"#4d4d4d","theme_field_colors_placeholder_focus":"#4d4d4d","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#fecb00","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"https:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"true","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"5","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-09-25","popup_till":"2016-09-25","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#ffffff","popup_close_btn_bg_color":"#000000","popup_close_btn_label":"","popup_close_btn_label_color":"#ffffff","popup_close_btn_label_bg_color":"","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"2","popup_close_btn_border_color":"#ffffff","popup_close_btn_top":"-15","popup_close_btn_right":"-15","popup_close_btn_padding":"","popup_close_btn_radius":"100","popup_enable_padding":"true","popup_padding":"30px 20px 0px 20px","popup_expire_trigger":"","popup_expire":"15","popup_width":"630","popup_background_color":"#211a3b","popup_overlay_color":"#000000","popup_overlay_opacity":"0.3","popup_background_image":"32612","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"from_top","popup_slide_duration":"1000","popup_fade_duration":"1000","popup_fade_out_duration":"500","popup_sticky":"default","popup_enable_borders":"true","popup_border_size":"0","popup_border_color":"#a7c1c5","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"true","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-12-18',
        ),
        array(
            'title' => 'Contact Form + reCAPTCHA',
            'description' => 'Simple contact form with reCAPTCHA',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/contact-form-recaptcha/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"first_name","email":"First name:","placeholder":"Your First Name","validation":"empty"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"last_name","email":"Last name:","placeholder":"Your Last Name","validation":"empty"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","icon":"envelope"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions...","icon":"question"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"recaptcha","group":"form_elements","data":{"align":"left"}}],"data":{"size":"1/3"}}]}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FF9A9A","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":""}',
            'date' => '2016-11-24',
        ),
        array(
            'title' => 'WooCommerce Charge Registration',
            'description' => 'Charge users for registering to your site',
            'requirements' => 'woocommerce,register_login',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/woocommerce-charge-registration/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"user_login","email":"Username","placeholder":"Username","validation":"empty"}},{"tag":"text","group":"form_elements","data":{"name":"user_email","email":"Email","placeholder":"Email","validation":"email","icon":"envelope"}},{"tag":"password","group":"form_elements","data":{"name":"user_pass","email":"Password","placeholder":"Password","validation":"empty","error":"Password should be at least 6 characters long!","minlength":"6","icon":"lock"}},{"tag":"password","group":"form_elements","data":{"name":"user_pass_confirm","email":"Confirm Password","placeholder":"Confirm Password","validation":"empty","conditional_validation":"equal","conditional_validation_value":"{user_pass}","error":"Password does not match!","minlength":"6","icon":"lock"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_max_width":"0","form_custom_css":"","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"register","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"pending","register_login_activation":"none","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"true","woocommerce_checkout_empty_cart":"true","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"26219|1","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active"}',
            'date' => '2016-09-19',
        ),
        array(
            'title' => 'WooCommerce Charge Posting Content',
            'description' => 'Charge users for uploading or publishing content to your site',
            'requirements' => 'woocommerce,frontend_posting',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/woocommerce-charge-posting-content/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"Add New Post:"}},{"tag":"text","group":"form_elements","data":{"name":"post_title","email":"Post title","placeholder":"Post title","validation":"empty","error":"Please enter a title for your post","error_position":"bottom-left"}},{"tag":"textarea","group":"form_elements","data":{"name":"post_content","email":"Post content","placeholder":"Post description","value":"Post description","error_position":"bottom-left","editor":"true","teeny":"true","icon":"question"}},{"tag":"file","group":"form_elements","data":{"name":"featured_image","email":"Page image","placeholder":"Upload feature image (2MB)","filesize":"2","maxlength":"1","error_position":"bottom-left","icon":"download"}},{"tag":"dropdown","group":"form_elements","data":{"name":"tax_input","email":"Post categories","retrieve_method":"taxonomy","placeholder":"- select a option -","icon":"toggle-down"}}]}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","save_contact_entry":"no","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"New post successfully created!","form_thanks_description":"Below you can view your post.","form_preload":"1","form_redirect_option":"custom","form_redirect":"http:\/\/f4d.nl\/super-forms\/blog-page\/","form_redirect_page":"","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_max_width":"0","form_custom_css":"","form_button":"Publish","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"create_post","frontend_posting_post_type":"post","frontend_posting_status":"pending","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"category","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"true","woocommerce_checkout_empty_cart":"true","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"1234|1","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active"}',
            'date' => '2016-09-19',
        ),
        array(
            'title' => 'RTL (Right to Left)',
            'description' => 'Form with RTL support enabled in theme settings',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/rtl-right-to-left/',
            'elements' => '[{"tag":"heading","group":"html_elements","data":{"title":"Title","heading_align":"right"}},{"tag":"html","group":"html_elements","data":{"html":"Test HTML text alignment"}},{"tag":"spacer","group":"html_elements"},{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","label":"test1","description":"test2","placeholder":"Your Email Address","validation":"email","icon":"envelope-o"}},{"tag":"dropdown","group":"form_elements","data":{"name":"title","email":"Title:","dropdown_items":[{"checked":false,"label":"Mr.","value":"Mr."},{"checked":false,"label":"Mis.","value":"Mis."}],"placeholder":"- select your title -","validation":"empty","icon":"toggle-down"}},{"tag":"text","group":"form_elements","data":{"name":"first_name","email":"First name:","placeholder":"Your First Name","validation":"empty","grouped":"1"}},{"tag":"text","group":"form_elements","data":{"name":"last_name","email":"Last name:","placeholder":"Your Last Name","validation":"empty","grouped":"2"}},{"tag":"text","group":"form_elements","data":{"name":"address","email":"Address:","placeholder":"Your Address","validation":"empty","icon":"map-marker"}},{"tag":"text","group":"form_elements","data":{"name":"zipcode","email":"Zipcode:","placeholder":"Zipcode","validation":"empty","grouped":"1","minlength":"4","icon":"map-marker"}},{"tag":"text","group":"form_elements","data":{"name":"city","email":"City:","placeholder":"City","validation":"empty","grouped":"2","minlength":"2"}},{"tag":"countries","group":"form_elements","data":{"name":"country","email":"Country:","placeholder":"- select your country -","icon":"globe"}},{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Your Full Name"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions...","icon":"question"}},{"tag":"dropdown","group":"form_elements","data":{"name":"option","email":"Option","dropdown_items":[{"checked":false,"label":"","value":""}],"placeholder":"- select a option -","icon":"toggle-down"}},{"tag":"checkbox","group":"form_elements","data":{"name":"option_1","email":"Option","checkbox_items":[{"checked":false,"image":"","label":"First choice","value":"first_choice"},{"checked":false,"image":"","label":"Second choice","value":"second_choice"},{"checked":false,"image":"","label":"Third choice","value":"third_choice"}],"label":"test1","description":"test2","display":"horizontal","icon":"check-square-o"}},{"tag":"radio","group":"form_elements","data":{"name":"option_2","email":"Option","radio_items":[{"checked":false,"image":"","label":"First choice","value":"first_choice"},{"checked":false,"image":"","label":"Second choice","value":"second_choice"},{"checked":false,"image":"","label":"Third choice","value":"third_choice"}],"label":"test1","description":"test2","display":"horizontal","icon":"dot-circle-o"}},{"tag":"quantity","group":"form_elements","data":{"name":"amount","email":"Amount","label":"test1","description":"test2","value":"0"}},{"tag":"slider","group":"form_elements","data":{"name":"amount_1","email":"Amount","label":"test1","description":"test2","value":"0","currency":"$","icon":"user"}},{"tag":"file","group":"form_elements","data":{"name":"file","email":"File","label":"test1","description":"test2","icon":"download"}},{"tag":"text","group":"form_elements","data":{"name":"phonenumber","email":"Phonenumber:","placeholder":"Your Phonenumber","validation":"phone","icon":"phone"}},{"tag":"text","group":"form_elements","data":{"name":"website","email":"Website:","placeholder":"http://","validation":"website","icon":"link"}},{"tag":"date","group":"form_elements","data":{"name":"date","email":"Date","placeholder":"Select a date","connected_min":"email","connected_max":"email","icon":"calendar"}},{"tag":"time","group":"form_elements","data":{"name":"time","email":"Time","placeholder":"Select a time","icon":"clock-o"}},{"tag":"rating","group":"form_elements","data":{"name":"rating","email":"Rating","label":"test1","description":"test2","validation":"none","icon":"heart"}},{"tag":"countries","group":"form_elements","data":{"name":"country_1","email":"Country","placeholder":"- select your country -","icon":"globe"}},{"tag":"password","group":"form_elements","data":{"name":"password","email":"Password","placeholder":"Password","icon":"lock"}},{"tag":"recaptcha","group":"form_elements"}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_hide_icons":"yes","theme_rtl":"true","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_max_width":"0","form_custom_css":"","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-07',
        ),
        array(
            'title' => 'Variable Fields',
            'description' => 'Simple example of how variable fields work and what you can do with it',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/variable-fields/',
            'elements' => '[{"tag":"quantity","group":"form_elements","data":{"name":"amount","email":"Amount","value":"0"}},{"tag":"hidden","group":"form_elements","data":{"name":"hidden","email":"Hidden","conditional_variable_action":"enabled","conditional_items":[{"field":"amount","logic":"equal","value":"1","and_method":"","field_and":"hidden","logic_and":"","value_and":"","new_value":"10"},{"field":"amount","logic":"not_equal","value":"1","and_method":"","field_and":"hidden","logic_and":"","value_and":"","new_value":"5"}]}},{"tag":"calculator","group":"form_elements","data":{"name":"subtotal","email":"Subtotal:","math":"{amount}+{hidden}","currency":"$"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Checkbox images',
            'description' => 'Example form of checkboxes turned into image checkbox (image selection)',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/checkbox-images/',
            'elements' => '[{"tag":"multipart","group":"layout_elements","inner":[{"tag":"radio","group":"form_elements","data":{"name":"option","email":"Option","radio_items":[{"checked":false,"image":"3966","label":"","value":"Jacket 1"},{"checked":false,"image":"3964","label":"","value":"Jacket 2"},{"checked":false,"image":"3962","label":"","value":"Jacket 3"}],"display":"horizontal","icon":"dot-circle-o"}}],"data":{"auto":"yes"}},{"tag":"multipart","group":"layout_elements","inner":[{"tag":"radio","group":"form_elements","data":{"name":"option_1","email":"Option","radio_items":[{"checked":false,"image":"3960","label":"","value":"Tshirt 1"},{"checked":false,"image":"3963","label":"","value":"Tshirt 2"},{"checked":false,"image":"3961","label":"","value":"Tshirt 3"}],"display":"horizontal","icon":"dot-circle-o"}}],"data":{"auto":"yes"}},{"tag":"multipart","group":"layout_elements","inner":[{"tag":"checkbox","group":"form_elements","data":{"name":"option_2","email":"Option","checkbox_items":[{"checked":false,"image":"3970","label":"","value":"Shoe 1"},{"checked":false,"image":"3971","label":"","value":"Shoe 2"},{"checked":false,"image":"3973","label":"","value":"Shoe 3"},{"checked":false,"image":"3972","label":"","value":"Shoe 4"}],"display":"horizontal","icon":"check-square-o"}}]},{"tag":"multipart","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Your Full Name"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions...","icon":"question"}}]}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Autosuggest Field',
            'description' => 'Example with auto suggest / auto complete based on user input',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/autosuggest-field/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"product","email":"Product","placeholder":"Search for Apple!","enable_auto_suggest":"true","autosuggest_items":[{"checked":false,"label":"apple","value":"apple"},{"checked":false,"label":"apple watch","value":"apple watch"},{"checked":false,"label":"app store","value":"app store"},{"checked":false,"label":"apple id","value":"apple id"}]}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"456","form_hide_after_submitting":"true","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","csv_attachment_enable":"","csv_attachment_save_as":"admin_email_value","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","password_protect":"","password_protect_password":"xMvODFZ@i76BWsw)H*MaQHTN","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-11-12","popup_till":"2016-11-12","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Validate Previous Value',
            'description' => 'Example usage for repeat password and repeat email address',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/validate-previous-value/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","error":"Invalid email address!","icon":"envelope-o"}},{"tag":"text","group":"form_elements","data":{"name":"email_1","email":"Email address (repeat):","placeholder":"Repeat Your Email Address","validation":"email","conditional_validation":"equal","conditional_validation_value":"{email}","error":"Your email address did not match!","exclude":"2","icon":"envelope-o"}},{"tag":"password","group":"form_elements","data":{"name":"password","email":"Password","placeholder":"Password","validation":"empty","error":"Password must be 6 characters long!","minlength":"6","icon":"lock"}},{"tag":"password","group":"form_elements","data":{"name":"password_repeat","email":"Password (repeat)","placeholder":"Repeat Password","conditional_validation":"equal","conditional_validation_value":"{password}","error":"Your passwords did not match!","exclude":"2","icon":"lock"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_recaptcha":"6LegRhMTAAAAAOh3SQk8S-YKmS3HWhuF7PprmtO9","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Service Estimate Calculation',
            'description' => 'Example form that calculates a total price based on user selected preferences',
            'requirements' => 'calculator',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/service-estimate-calculation/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"radio","group":"form_elements","data":{"name":"emails","email":"Total emails:","radio_items":[{"checked":false,"image":"","label":"None","value":"0"},{"checked":false,"image":"","label":"1 (Free)","value":"0"},{"checked":false,"image":"","label":"2 - 5","value":"6"},{"checked":false,"image":"","label":"5+","value":"10"}],"label":"Total of email addresses","description":"How many email addresses you need for your domain?","validation":"empty","display":"horizontal","icon":"paper-plane-o"}}],"data":{"size":"2/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_email","email":"Email total:","math":"{emails}","currency":"$","label":" ","description":" ","align":"right","icon_position":"inside"}}],"data":{"size":"1/3"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"quantity","group":"form_elements","data":{"name":"domains","email":"Domains","label":"Total of domain names","description":"Select how many domain names you want to register","value":"0"}}],"data":{"size":"2/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_domains","email":"Email total:","math":"{domains}*1.8","currency":"$","label":" ","description":" ","align":"right","icon_position":"inside"}}],"data":{"size":"1/3"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"checkbox","group":"form_elements","data":{"name":"protection","email":"Protection:","checkbox_items":[{"checked":false,"image":"","label":"Malware scans","value":"0"},{"checked":false,"image":"","label":"Daily Backup ($3)","value":"3"},{"checked":false,"image":"","label":"Montly updates ($10)","value":"10"}],"label":"Website anti-virus, backups and updates","description":"Select all the protections  you want","display":"horizontal","icon":"bug"}}],"data":{"size":"3/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_protection","email":"Protection total:","math":"{protection}","currency":"$","label":" ","description":" ","align":"right","icon_position":"inside"}}],"data":{"size":"1/4"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"slider","group":"form_elements","data":{"name":"scans","email":"Storage:","label":"Select how many scans you want per week","description":"How many Malware scans do you want per week?","value":"1","format":" scan p/w","minnumber":"1","maxnumber":"50","icon":"database"}}],"data":{"size":"2/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_scans","email":"Scans total:","math":"{scans}*5","currency":"$","label":" ","description":" ","align":"right","icon_position":"inside"}}],"data":{"size":"1/3"}}],"data":{"conditional_action":"show","conditional_items":[{"field":"protection","logic":"contains","value":"0","and_method":"","field_and":"emails","logic_and":"","value_and":""}]}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"slider","group":"form_elements","data":{"name":"storage","email":"Storage:","label":"Select your total storage","description":"How much storage would you need on your new server?","value":"20","format":" GB","currency":"$","minnumber":"10","icon":"database"}}],"data":{"size":"2/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_storage","email":"Storage total:","math":"{storage}*1.5","currency":"$","label":" ","description":" ","align":"right","icon_position":"inside"}}],"data":{"size":"1/3"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"checkbox","group":"form_elements","data":{"name":"seo","email":"SEO:","checkbox_items":[{"checked":false,"image":"","label":"Off-site SEO ($6)","value":"6"},{"checked":false,"image":"","label":"On-site SEO ($10)","value":"10"}],"label":"Optimise my website for search engines","description":"Select if you would like Off-site and/or On-site optimisation:","display":"horizontal","icon":"tachometer"}}],"data":{"size":"3/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"total_seo","email":"SEO total:","math":"{seo}","currency":"$","label":" ","description":" ","align":"right","icon_position":"inside"}}],"data":{"size":"1/4"}},{"tag":"divider","group":"html_elements","data":{"padding_top":"0"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"subtotal","email":"Subtotal:","math":"{total_email}+{total_domains}+{total_protection}+{total_scans}+{total_storage}+{total_seo}","amount_label":"Subtotal:","currency":"$","align":"right","amount_width":"100","margin":"no_margin","icon_position":"inside"}},{"tag":"calculator","group":"form_elements","data":{"name":"vat","email":"VAT:","math":"({subtotal}/100)*21","amount_label":"VAT (21%):","currency":"$","align":"right","amount_width":"100","margin":"no_margin","icon_position":"inside"}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"3/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"divider","group":"html_elements","data":{"padding_top":"10","padding_bottom":"10"}}],"data":{"size":"1/4"}},{"tag":"calculator","group":"form_elements","data":{"name":"total","email":"Total:","math":"{subtotal}+{vat}","amount_label":"Total:","currency":"$","email_float":"true","align":"right","amount_width":"100","margin":"no_margin","icon_position":"inside"}},{"tag":"spacer","group":"html_elements"},{"tag":"button","group":"form_elements","data":{"name":"Setup my WordPress website!"}}]}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"","theme_field_description":"","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Dynamic Fields (add more +)',
            'description' => 'Allows users to dynamically add a new set of fields (with or without a limitation)',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/dynamic-fields-add-more/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","error":"Invalid email address!","icon":"envelope-o"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"html","group":"html_elements","data":{"html":"Let us know what your favorite hobby\'s are: "}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"html","group":"html_elements","data":{"html":"What websites did you create?"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"hobby","email":"Hobby:","placeholder":"Enter a hobby","validation":"empty","error":"Please enter a hobby!","icon":"futbol-o"}}],"data":{"size":"1/2","duplicate":"enabled"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"website","email":"Website:","placeholder":"http://","validation":"website","error":"Please enter a valid domain name!","icon":"link"}}],"data":{"size":"1/2","duplicate":"enabled"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_recaptcha":"6LegRhMTAAAAAOh3SQk8S-YKmS3HWhuF7PprmtO9","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Accept Terms of Service',
            'description' => 'Let users first accept the terms of service before being able to submit the form',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/accept-terms-of-service/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Your Full Name"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions..."}},{"tag":"checkbox","group":"form_elements","data":{"name":"terms","email":"Terms accepted:","checkbox_items":[{"checked":false,"image":"","label":"I accept the <a href=\"#\">terms of service</a>","value":"yes"}],"validation":"empty","error":"You need to read and accept to our terms of service!","error_position":"bottom-left"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"custom","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"2d","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","csv_attachment_enable":"","csv_attachment_save_as":"admin_email_value","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","password_protect":"","password_protect_password":"xMvODFZ@i76BWsw)H*MaQHTN","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-11-12","popup_till":"2016-11-12","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Prevent Submit on specific value',
            'description' => 'This examples shows you how you can easily hide the submit button based on a specific condition',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/prevent-submit-on-specific-value/',
            'elements' => '[{"tag":"quantity","group":"form_elements","data":{"name":"amount","email":"Amount","value":"0"}},{"tag":"hidden","group":"form_elements","data":{"name":"hidden","email":"Hidden","conditional_variable_action":"enabled","conditional_items":[{"field":"amount","logic":"greater_than","value":"5","and_method":"and","field_and":"amount","logic_and":"less_than","value_and":"10","new_value":"1"}]}},{"tag":"html","group":"html_elements","data":{"html":"Value is between 5 and 10, we can submit the form :)","conditional_action":"show","conditional_trigger":"one","conditional_items":[{"field":"hidden","logic":"equal","value":"1","and_method":"","field_and":"amount","logic_and":"","value_and":""}]}},{"tag":"html","group":"html_elements","data":{"html":"Value is NOT between 5 and 10, we are not allowed to submit the form :(","conditional_action":"show","conditional_trigger":"one","conditional_items":[{"field":"hidden","logic":"not_equal","value":"1","and_method":"","field_and":"amount","logic_and":"","value_and":""}]}},{"tag":"column","group":"layout_elements","inner":[{"tag":"spacer","group":"html_elements"},{"tag":"button","group":"form_elements","data":{"name":"Submit"}}],"data":{"conditional_action":"show","conditional_trigger":"one","conditional_items":[{"field":"hidden","logic":"equal","value":"1","and_method":"","field_and":"amount","logic_and":"","value_and":""}]}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","popup_enabled":"","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-08-23","popup_till":"2016-08-23","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"1","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"inherit","popup_close_button":"true","popup_slide":"default","popup_fade_duration":"1000","popup_sticky":"default","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"0","popup_border_radius_top_right":"0","popup_border_radius_bottom_left":"0","popup_border_radius_bottom_right":"0","popup_shadow_horizontal_length":"0","popup_shadow_vertical_length":"0","popup_blur_radius":"0","popup_spread_radius":"0","popup_shadow_color":"#00bc65","popup_shadow_opacity":"0"}',
            'date' => '2016-09-06',
        ),
        array(
            'title' => 'Create WordPress Post (Simple)',
            'description' => 'Simple form example that creates a new WordPress Post',
            'requirements' => 'frontend_posting',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/create-wordpress-post-simple/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"Add New Post:"}},{"tag":"text","group":"form_elements","data":{"name":"post_title","email":"Post title","placeholder":"Post title","validation":"empty","error":"Please enter a title for your post","error_position":"bottom-left"}},{"tag":"textarea","group":"form_elements","data":{"name":"post_content","email":"Post content","placeholder":"Post description","value":"Post description","error_position":"bottom-left","editor":"true","teeny":"true","icon":"question"}},{"tag":"file","group":"form_elements","data":{"name":"featured_image","email":"Page image","placeholder":"Upload feature image (2MB)","filesize":"2","maxlength":"1","error_position":"bottom-left","icon":"download"}},{"tag":"dropdown","group":"form_elements","data":{"name":"tax_input","email":"Post categories","retrieve_method":"taxonomy","placeholder":"- select a option -","icon":"toggle-down"}}]}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"New post successfully created!","form_thanks_description":"Below you can view your post.","form_preload":"1","form_redirect_option":"custom","form_redirect":"http:\/\/f4d.nl\/super-forms\/blog-page\/","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Publish","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"create_post","frontend_posting_post_type":"post","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"category","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-05',
        ),
        array(
            'title' => 'Create WordPress Post (Advanced)',
            'description' => 'Advanced form example that creates a new WordPress Post',
            'requirements' => 'frontend_posting',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/create-wordpress-post/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"Add New Post:"}},{"tag":"text","group":"form_elements","data":{"name":"post_title","email":"Post title","placeholder":"Post title","validation":"empty","error":"Please enter a title for your post","error_position":"bottom-left"}},{"tag":"textarea","group":"form_elements","data":{"name":"post_content","email":"Post content","placeholder":"Post description","value":"Post description","error_position":"bottom-left","editor":"true","teeny":"true","icon":"question"}},{"tag":"textarea","group":"form_elements","data":{"name":"post_excerpt","email":"Post excerpt","placeholder":"Post excerpt","value":"Post excerpt","error_position":"bottom-left","editor":"true","teeny":"true","icon":"question"}},{"tag":"file","group":"form_elements","data":{"name":"featured_image","email":"Page image","placeholder":"Upload feature image (2MB)","filesize":"2","maxlength":"1","error_position":"bottom-left","icon":"download"}},{"tag":"dropdown","group":"form_elements","data":{"name":"post_status","email":"Post status","dropdown_items":[{"checked":false,"label":"Publish","value":"publish"},{"checked":false,"label":"Future","value":"future"},{"checked":false,"label":"Draft","value":"draft"},{"checked":false,"label":"Pending","value":"pending"},{"checked":false,"label":"Private","value":"private"},{"checked":false,"label":"Trash","value":"trash"}],"placeholder":"- post status -","validation":"empty","error":"Please select a post status","icon":"toggle-down"}},{"tag":"date","group":"form_elements","data":{"name":"post_date","email":"Publish date","placeholder":"Schedule date","format":"yy-mm-dd","grouped":"1","minlength":"0","icon":"calendar","conditional_action":"show","conditional_items":[{"field":"post_status","logic":"equal","value":"future","and_method":"","field_and":"post_title","logic_and":"","value_and":""}]}},{"tag":"time","group":"form_elements","data":{"name":"post_time","email":"Publish time","placeholder":"Select a time","validation":"empty","grouped":"2","icon":"clock-o","conditional_action":"show","conditional_items":[{"field":"post_status","logic":"equal","value":"future","and_method":"","field_and":"post_title","logic_and":"","value_and":""}]}},{"tag":"dropdown","group":"form_elements","data":{"name":"visibility","email":"Post visibility ","dropdown_items":[{"checked":false,"label":"Public","value":"public"},{"checked":false,"label":"Password protected","value":"password"},{"checked":false,"label":"Private","value":"private"}],"placeholder":"- post visibility -","icon":"toggle-down"}},{"tag":"checkbox","group":"form_elements","data":{"name":"stick_post","email":"Sticky","checkbox_items":[{"checked":false,"image":"","label":"Stick this post to the front page","value":"true"}],"icon":"check-square-o","conditional_action":"show","conditional_items":[{"field":"visibility","logic":"equal","value":"public","and_method":"","field_and":"post_title","logic_and":"","value_and":""}]}},{"tag":"text","group":"form_elements","data":{"name":"post_password","email":"Post password","placeholder":"Enter a password","validation":"empty","error":"Enter a password","conditional_action":"show","conditional_items":[{"field":"visibility","logic":"equal","value":"password","and_method":"","field_and":"post_title","logic_and":"","value_and":""}]}},{"tag":"dropdown","group":"form_elements","data":{"name":"page_template","email":"Page template","dropdown_items":[{"checked":false,"label":"Default Template","value":"default"},{"checked":false,"label":"Page Full Width","value":"template-page-full-width.php"},{"checked":false,"label":"Portfolio masonry","value":"template-portfolio-masonry-2.php"}],"placeholder":"- page template -","validation":"empty","error":"Please select a page template","icon":"toggle-down"}}]}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","form_duration":"500","form_thanks_title":"Thank you for contributing!","form_thanks_description":"We will review your post soon.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"create_post","frontend_posting_post_type":"post","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"page_template|_wp_page_template","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_tags_input":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","password_protect":"","password_protect_password":"qCH^!9Dwa*oKQLn(q)9mKLBT","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!"}',
            'date' => '2016-09-05',
        ),
        array(
            'title' => 'Create WordPress Page',
            'description' => 'Form example that creates a new WordPress page',
            'requirements' => 'frontend_posting',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/create-wordpress-page/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"Add New Page:"}},{"tag":"text","group":"form_elements","data":{"name":"post_title","email":"Page title","placeholder":"Page title","validation":"empty","error":"Please enter a title for your page","error_position":"bottom-left"}},{"tag":"textarea","group":"form_elements","data":{"name":"post_content","email":"Page content","placeholder":"Page description","value":"Page description","error_position":"bottom-left","editor":"true","teeny":"true","icon":"question"}},{"tag":"file","group":"form_elements","data":{"name":"featured_image","email":"Page image","placeholder":"Upload feature image (2MB)","filesize":"2","maxlength":"1","error_position":"bottom-left","icon":"download"}},{"tag":"dropdown","group":"form_elements","data":{"name":"post_parent","email":"Post parent","retrieve_method":"post_type","retrieve_method_post":"page","retrieve_method_value":"id","placeholder":"- parent page -","icon":"toggle-down"}},{"tag":"dropdown","group":"form_elements","data":{"name":"post_status","email":"Page status","dropdown_items":[{"checked":false,"label":"Publish","value":"publish"},{"checked":false,"label":"Future","value":"future"},{"checked":false,"label":"Draft","value":"draft"},{"checked":false,"label":"Pending","value":"pending"},{"checked":false,"label":"Private","value":"private"},{"checked":false,"label":"Trash","value":"trash"}],"placeholder":"- page status -","validation":"empty","error":"Please select a page status","icon":"toggle-down"}},{"tag":"date","group":"form_elements","data":{"name":"post_date","email":"Publish date","placeholder":"Schedule date","format":"yy-mm-dd","grouped":"1","minlength":"0","icon":"calendar","conditional_action":"show","conditional_items":[{"field":"post_status","logic":"equal","value":"future","and_method":"","field_and":"post_title","logic_and":"","value_and":""}]}},{"tag":"time","group":"form_elements","data":{"name":"post_time","email":"Publish time","placeholder":"Select a time","validation":"empty","grouped":"2","icon":"clock-o","conditional_action":"show","conditional_items":[{"field":"post_status","logic":"equal","value":"future","and_method":"","field_and":"post_title","logic_and":"","value_and":""}]}},{"tag":"dropdown","group":"form_elements","data":{"name":"page_template","email":"Page template","dropdown_items":[{"checked":false,"label":"Default Template","value":"default"},{"checked":false,"label":"Page Full Width","value":"template-page-full-width.php"},{"checked":false,"label":"Portfolio masonry","value":"template-portfolio-masonry-2.php"}],"placeholder":"- page template -","validation":"empty","error":"Please select a page template","icon":"toggle-down"}}]}]',
            'settings' => '{"send":"no","header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_reply_enabled":"","header_reply":"{option_admin_email}","header_reply_name":"{option_blogname}","header_subject":"Super Forms","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_header_reply_enabled":"","confirm_header_reply":"{option_admin_email}","confirm_header_reply_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","admin_attachments":"","confirm_attachments":"","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","contact_entry_custom_status":"","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","save_form_progress":"","update_contact_entry":"","contact_entry_custom_status_update":"","retrieve_last_entry_data":"","retrieve_last_entry_form":"","form_show_thanks_msg":"true","form_thanks_title":"Thank you for contributing!","form_thanks_description":"We will review your page soon.","form_preload":"1","form_duration":"500","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_google_places_api":"","form_post_option":"","form_post_url":"","form_post_custom":"","form_post_parameters":"","form_post_timeout":"5","form_post_http_version":"1.0","form_post_debug":"","form_disable_enter":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_enable_ga_tracking":"","form_ga_code":"","form_ga_tracking":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","form_locker":"","form_locker_limit":10,"form_locker_submission_reset":0,"form_locker_msg":"true","form_locker_msg_title":"Please note:","form_locker_msg_desc":"This form is no longer available","form_locker_hide":"true","form_locker_reset":"","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_center_form":"","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_tags_bg":"#4EB1B6","theme_ui_tags_font":"#ffffff","theme_ui_tags_remove":"#2e8a90","theme_ui_tags_remove_hover":"#246569","theme_ui_tags_list_bg_hover":"#fdecde","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_multipart_progress_bar":"true","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_multipart_steps":"true","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":12,"font_label_size":16,"font_description_size":14,"font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_status":"pending|Pending|#808080|#FFFFFF\nprocessing|Processing|#808080|#FFFFFF\non_hold|On hold|#FF7700|#FFFFFF\naccepted|Accepted|#2BC300|#FFFFFF\ncompleted|Completed|#2BC300|#FFFFFF\ncancelled|Cancelled|#E40000|#FFFFFF\ndeclined|Declined|#E40000|#FFFFFF\nrefunded|Refunded|#000000|#FFFFFF","backend_contact_entry_list_form":"true","backend_contact_entry_list_ip":"","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","csv_attachment_enable":"","csv_attachment_name":"super-csv-attachment","csv_attachment_save_as":"admin_email_value","csv_attachment_exclude":"","csv_attachment_delimiter":",","csv_attachment_enclosure":"\"","frontend_posting_action":"create_post","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"page_template|_wp_page_template","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","password_protect":"","password_protect_password":"qCH^!9Dwa*oKQLn(q)9mKLBT","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","password_protect_show_login_after_submit":"true","password_protect_not_login_hide":"","paypal_checkout":"","paypal_mode":"","paypal_merchant_email":"","paypal_currency_code":"USD","paypal_no_shipping":"0","paypal_payment_type":"_xclick","paypal_item_name":"Flower (roses)","paypal_item_amount":"5.00","paypal_item_quantity":"1","paypal_item_weight":"","paypal_item_number":"","paypal_item_discount_amount":"","paypal_item_discount_rate":"","paypal_item_discount_num":"","paypal_item_shipping":"","paypal_item_shipping2":"","paypal_subscription_periods":"","paypal_cart_items":"","paypal_tax_cart":"","paypal_weight_cart":"","paypal_discount_amount_cart":"","paypal_discount_rate_cart":"","paypal_handling_cart":"","paypal_custom_return_url":"","paypal_return_url":"http:\/\/f4d.nl\/super-forms\/my-custom-thank-you-page","paypal_cancel_url":"http:\/\/f4d.nl\/super-forms\/my-custom-canceled-page","paypal_advanced_settings":"","paypal_lc":"US","paypal_charset":"UTF-8","paypal_handling":"","paypal_undefined_quantity":"","paypal_weight_unit":"lbs","paypal_invoice":"","paypal_night_phone_a":"","night_phone_b":"","night_phone_c":"","paypal_custom_address":"","paypal_address_override":"","paypal_first_name":"","paypal_last_name":"","paypal_email":"","paypal_address1":"","paypal_address2":"","paypal_city":"","paypal_state":"","paypal_zip":"","paypal_country":"","paypal_completed_entry_status":"completed","paypal_notify_url":"","paypal_completed_post_status":"publish","paypal_completed_signup_status":"active","register_login_action":"none","register_login_action_skip_register":"","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_send_approve_email":"","register_approve_subject":"Account has been approved","register_approve_email":"Dear {user_login},\n\nYour account has been approved and can now be used!\n\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{user_pass}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login into your account.\n\n\nBest regards,\n\n{option_blogname}","register_approve_generate_pass":"","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_login_multisite_enabled":"","register_login_multisite_domain":"{user_email}","register_login_multisite_path":"{user_email}","register_login_multisite_title":"{user_email}","register_login_multisite_id":"1","register_login_multisite_email":"true","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","register_login_not_logged_in_msg":"You must be logged in to submit this form. Click <a href=\"{register_login_url}\">here<\/a> to login!","register_login_update_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_checkout_fields":"","woocommerce_checkout_fields_skip_empty":"","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2018-01-27","popup_till":"2018-01-27","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no_repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307"}',
            'date' => '2016-09-05',
        ),
        array(
            'title' => 'Create BbPress Topic',
            'description' => 'Allows users to create a new BbPress Topic from the front-end',
            'requirements' => 'frontend_posting',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/create-bbpress-topic/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"post_title","email":"Topic Title:","label":"Topic Title:","placeholder":"Enter title here","validation":"empty","enable_auto_suggest":"true","retrieve_method":"taxonomy"}},{"tag":"dropdown","group":"form_elements","data":{"name":"_bbp_topic_type","email":"Topic Type:","dropdown_items":[{"checked":false,"label":"Normal","value":"unstick"},{"checked":false,"label":"Sticky","value":"stick"},{"checked":false,"label":"Super Sticky","value":"super"}],"label":"Topic Type:","placeholder":"- select a option -","validation":"empty","icon":"toggle-down"}},{"tag":"dropdown","group":"form_elements","data":{"name":"post_status","email":"Topic Status:","dropdown_items":[{"checked":false,"label":"Open","value":"publish"},{"checked":false,"label":"Closed","value":"closed"},{"checked":false,"label":"Spam","value":"spam"},{"checked":false,"label":"Trash","value":"trash"},{"checked":false,"label":"Pending","value":"pending"}],"label":"Topic Status:","placeholder":"- select a option -","validation":"empty","icon":"toggle-down"}},{"tag":"dropdown","group":"form_elements","data":{"name":"post_parent","email":"Topic Parent:","retrieve_method":"post_type","retrieve_method_post":"forum","label":"Topic Parent:","placeholder":"- select a option -","validation":"empty","icon":"toggle-down"}},{"tag":"checkbox","group":"form_elements","data":{"name":"bbp_subscribe","email":"Notify follow-up replies:","checkbox_items":[{"checked":false,"image":"","label":"Notify me of follow-up replies via email","value":"true"}],"icon":"check-square-o"}},{"tag":"textarea","group":"form_elements","data":{"name":"post_content","email":"Page content","editor":"true","teeny":"true","icon":"question"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","csv_attachment_enable":"","csv_attachment_save_as":"admin_email_value","frontend_posting_action":"create_post","frontend_posting_post_type":"topic","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","password_protect":"","password_protect_password":"5iDCRQE9tzEx6tlc!4$r%ux2","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-11-12","popup_till":"2016-11-12","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-09-05',
        ),
        array(
            'title' => 'Create BbPress Forum',
            'description' => 'Create BbPress Forum',
            'requirements' => 'frontend_posting',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/create-bbpress-forum/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"post_title","email":"Forum Title:","label":"Forum Title:","placeholder":"Enter title here","enable_auto_suggest":"true","retrieve_method":"taxonomy"}},{"tag":"dropdown","group":"form_elements","data":{"name":"_bbp_forum_type","email":"Forum Type:","dropdown_items":[{"checked":false,"label":"Forum","value":"forum"},{"checked":false,"label":"Category","value":"category"}],"label":"Forum Type:","placeholder":"- select a option -","validation":"empty","icon":"toggle-down"}},{"tag":"dropdown","group":"form_elements","data":{"name":"_bbp_status","email":"Forum Status:","dropdown_items":[{"checked":false,"label":"Open","value":"open"},{"checked":false,"label":"Closed","value":"closed"}],"label":"Forum Status:","placeholder":"- select a option -","validation":"empty","icon":"toggle-down"}},{"tag":"dropdown","group":"form_elements","data":{"name":"post_status","email":"Forum Visibility:","dropdown_items":[{"checked":false,"label":"Public","value":"public"},{"checked":false,"label":"Private","value":"private"},{"checked":false,"label":"Hidden","value":"hidden"}],"label":"Forum Visibility:","placeholder":"- select a option -","validation":"empty","icon":"toggle-down"}},{"tag":"textarea","group":"form_elements","data":{"name":"post_content","email":"Page content","editor":"true","teeny":"true","icon":"question"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"create_post","frontend_posting_post_type":"forum","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"_bbp_status|_bbp_status\n_bbp_forum_type|_bbp_forum_type","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_tags_input":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","password_protect":"","password_protect_password":"Y0mLLG^hKzx^JL&at^lvJH6R","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!"}',
            'date' => '2016-09-05',
        ),
        array( // #11
            'title' => 'Create WooCommerce Product',
            'description' => 'Allows users to create a new WooCommerce Product from the front-end',
            'requirements' => 'frontend_posting',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/create-woocommerce-product/',
            'elements' => '[ { "tag": "multipart", "group": "layout_elements", "inner": [ { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "heading", "group": "html_elements", "data": { "title": "Product information:" } }, { "tag": "dropdown", "group": "form_elements", "data": { "name": "product_type", "email": "Product type", "dropdown_items": [ { "checked": "false", "label": "Simple product", "value": "simple" }, { "checked": "false", "label": "Grouped product", "value": "grouped" }, { "checked": "false", "label": "External/Affiliate product", "value": "external" }, { "checked": "false", "label": "Variable product", "value": "variable" } ], "placeholder": "Product type", "placeholderFilled": "Product type", "validation": "empty", "error": "Please select a product type", "wrapper_width": "300", "error_position": "bottom-left", "icon": "toggle-down" } }, { "tag": "dropdown", "group": "form_elements", "data": { "name": "tax_input", "email": "Product categorie(s)", "retrieve_method": "taxonomy", "retrieve_method_taxonomy": "product_cat", "placeholder": "- product categorie(s) -", "validation": "empty", "error": "Select one or more product categories", "maxlength": "100", "minlength": "1", "wrapper_width": "300", "error_position": "bottom-left", "icon": "toggle-down" } }, { "tag": "text", "group": "form_elements", "data": { "name": "tags_input", "tag_taxonomy": "product_tag", "email": "Product tags", "description": "product tags (comma separated)", "placeholder": "Product tags", "error_position": "bottom-left" } }, { "tag": "hidden", "group": "form_elements", "data": { "name": "tag_taxonomy", "email": "Tag taxonomy", "value": "product_tag" } }, { "tag": "text", "group": "form_elements", "data": { "name": "post_title", "email": "Product title", "placeholder": "Product title", "validation": "empty", "error": "Please enter a title for your product", "error_position": "bottom-left" } }, { "tag": "textarea", "group": "form_elements", "data": { "name": "post_content", "email": "Page content", "placeholder": "Product description", "value": "Product description", "error_position": "bottom-left", "editor": "true", "teeny": "true", "icon": "question" } } ] }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "checkbox", "group": "form_elements", "data": { "name": "product_virtual", "email": "Virtual product", "checkbox_items": [ { "checked": false, "image": "", "label": "Virtual product", "value": "yes" } ], "error_position": "bottom-left", "icon": "check-square-o" } } ], "data": { "size": "1/4" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "checkbox", "group": "form_elements", "data": { "name": "product_downloadable", "email": "Downloadable product", "checkbox_items": [ { "checked": false, "image": "", "label": "Downloadable product", "value": "yes" } ], "error_position": "bottom-left", "icon": "check-square-o" } } ], "data": { "size": "1/4" } } ], "data": { "conditional_action": "show", "conditional_items": [ { "field": "product_type", "logic": "equal", "value": "simple", "and_method": "", "field_and": "post_title", "logic_and": "", "value_and": "" } ] } } ], "data": { "icon": "user" } }, { "tag": "multipart", "group": "layout_elements", "inner": [ { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "heading", "group": "html_elements", "data": { "title": "Product images:" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "file", "group": "form_elements", "data": { "name": "featured_image", "email": "Product image", "placeholder": "Upload product image (2MB)", "filesize": "2", "maxlength": "1", "error_position": "bottom-left", "icon": "download" } } ], "data": { "size": "1/2" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "file", "group": "form_elements", "data": { "name": "image_gallery", "email": "Product image gallery", "placeholder": "Upload image gallery  (2MB per image)", "filesize": "2", "maxlength": "4", "error_position": "bottom-left", "icon": "download" } } ], "data": { "size": "1/2" } } ], "data": { "duplicate_limit": 0, "duplicate_dynamically": "true", "label": "Column", "bg_opacity": 1, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "divider", "group": "html_elements", "data": { "color": "#444444", "border": "single", "thickness": 1, "height": 1, "border_style": "dashed", "width": "100", "custom_width": "150px", "align": "left", "back": "0", "padding_top": 20, "padding_bottom": 20, "pdfOption": "none" } }, { "tag": "heading", "group": "html_elements", "data": { "title": "General:" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "text", "group": "form_elements", "data": { "name": "product_url", "email": "Product URL", "label": "Product URL", "description": "Enter the external URL to the product.", "placeholder": "http://", "validation": "website", "error_position": "bottom-left" } }, { "tag": "text", "group": "form_elements", "data": { "name": "product_button_text", "email": "Button text", "label": "Button text", "description": "This text will be shown on the button linking to the external product.", "placeholder": "Buy product", "validation": "website", "error_position": "bottom-left" } } ], "data": { "conditional_action": "show", "conditional_items": [ { "field": "product_type", "logic": "equal", "value": "external", "and_method": "", "field_and": "post_title", "logic_and": "", "value_and": "" } ] } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "currency", "group": "form_elements", "data": { "name": "product_regular_price", "email": "Regular price:", "placeholder": "Regular price", "placeholderFilled": "Regular price", "currency": "$", "thousand_separator": ",", "conditional_validation": "greater_than", "conditional_validation_value": "{product_sale_price}", "error": "Invalid number or less than sale price!", "icon": "dollar-sign" } }, { "tag": "currency", "group": "form_elements", "data": { "name": "product_sale_price", "email": "Sale price:", "placeholder": "Sale price", "placeholderFilled": "Sale price", "currency": "$", "thousand_separator": ",", "error": "Invalid number or less than sale price!", "icon": "dollar-sign" } }, { "tag": "checkbox", "group": "form_elements", "data": { "name": "schedule_sale_price", "email": "Schedule sale price", "checkbox_items": [ { "checked": false, "image": "", "label": "Schedule sale price", "value": "yes" } ], "error_position": "bottom-left", "icon": "check-square-o" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "date", "group": "form_elements", "data": { "name": "product_sale_price_dates_from", "email": "Product sale price  from", "label": "Product sale price  from", "format": "yy-mm-dd", "minlength": "1", "current_date": "true", "showMonthAfterYear": "", "showWeek": "", "showOtherMonths": "", "connected_min": "product_sale_price_dates_to", "connected_min_days": "0", "grouped": "1", "wrapper_width": "200", "error_position": "bottom-left", "icon": "calendar" } }, { "tag": "date", "group": "form_elements", "data": { "name": "product_sale_price_dates_to", "email": "Product sale price to", "label": "Product sale price to", "format": "yy-mm-dd", "current_date": "true", "showMonthAfterYear": "", "showWeek": "", "showOtherMonths": "", "connected_min_days": "0", "grouped": "2", "wrapper_width": "200", "error_position": "bottom-left", "icon": "calendar" } } ], "data": { "conditional_action": "show", "conditional_items": [ { "field": "schedule_sale_price", "logic": "equal", "value": "yes", "and_method": "", "field_and": "post_title", "logic_and": "", "value_and": "" } ] } } ], "data": { "duplicate_limit": 0, "duplicate_dynamically": "true", "label": "Column", "bg_opacity": 1, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "divider", "group": "html_elements", "data": { "color": "#444444", "border": "single", "thickness": 1, "height": 1, "border_style": "dashed", "width": "100", "custom_width": "150px", "align": "left", "back": "0", "padding_top": 20, "padding_bottom": 20, "pdfOption": "none" } }, { "tag": "dropdown", "group": "form_elements", "data": { "name": "product_download_type", "email": "Download type", "dropdown_items": [ { "checked": false, "label": "Standard Product", "value": "" }, { "checked": true, "label": "Application/Software", "value": "application" }, { "checked": false, "label": "Music", "value": "music" } ], "label": "Download type", "description": "Choose a download type - this controls the <a target=\"_blank\" href=\"http://schema.org/\">schema</a>.", "error_position": "bottom-left", "icon": "toggle-down" } }, { "tag": "file", "group": "form_elements", "data": { "name": "downloadable_files", "email": "File", "placeholder": "Upload downloadable files...", "error_position": "bottom-left", "icon": "download" } }, { "tag": "quantity", "group": "form_elements", "data": { "name": "product_download_limit", "email": "Amount", "label": "Download limit", "description": "Leave blank for unlimited re-downloads.", "error_position": "bottom-left" } }, { "tag": "quantity", "group": "form_elements", "data": { "name": "product_download_expiry", "email": "Amount", "label": "Download expiry", "description": "Enter the number of days before a download link expires, or leave blank.", "error_position": "bottom-left" } } ], "data": { "conditional_action": "show", "conditional_trigger": "one", "conditional_items": [ { "field": "product_downloadable", "logic": "equal", "value": "yes", "and_method": "", "field_and": "post_title", "logic_and": "", "value_and": "" } ] } } ], "data": { "conditional_action": "show", "conditional_trigger": "one", "conditional_items": [ { "field": "product_type", "logic": "equal", "value": "simple", "and_method": "or", "field_and": "product_type", "logic_and": "equal", "value_and": "external" } ] } }, { "tag": "spacer", "group": "html_elements", "data": { "height": 50, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } } ], "data": { "auto": "no", "prev_text": "Prev", "next_text": "Next", "step_name": "Step 1", "step_description": "Description for this step", "pdfOption": "none" } }, { "tag": "multipart", "group": "layout_elements", "inner": [ { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "heading", "group": "html_elements", "data": { "title": "Inventory:" } }, { "tag": "text", "group": "form_elements", "data": { "name": "product_sku", "email": "SKU", "label": "SKU", "validation": "numeric", "may_be_empty": "true", "error_position": "bottom-left" } }, { "tag": "checkbox", "group": "form_elements", "data": { "name": "product_manage_stock", "email": "Manage stock?", "checkbox_items": [ { "checked": false, "image": "", "label": "Enable stock management at product level", "value": "yes" } ], "label": "Manage stock?", "error_position": "bottom-left", "icon": "check-square-o" } }, { "tag": "quantity", "group": "form_elements", "data": { "name": "product_stock", "email": "Stock quantity", "label": "Stock quantity", "error_position": "bottom-left", "conditional_action": "show", "conditional_trigger": "one", "conditional_items": [ { "field": "product_manage_stock", "logic": "equal", "value": "yes", "and_method": "", "field_and": "post_title", "logic_and": "", "value_and": "" } ] } }, { "tag": "dropdown", "group": "form_elements", "data": { "name": "product_backorders", "email": "Allow backorders?", "dropdown_items": [ { "checked": true, "label": "Do not allow", "value": "no" }, { "checked": false, "label": "Allow, but notify customer", "value": "notify" }, { "checked": false, "label": "Allow", "value": "yes" } ], "label": "Allow backorders?", "error_position": "bottom-left", "icon": "toggle-down", "conditional_action": "show", "conditional_trigger": "one", "conditional_items": [ { "field": "{product_manage_stock}", "logic": "equal", "value": "yes", "and_method": "", "field_and": "{post_title}", "logic_and": "", "value_and": "" } ] } }, { "tag": "dropdown", "group": "form_elements", "data": { "name": "product_stock_status", "email": "Stock status", "dropdown_items": [ { "checked": true, "label": "In stock", "value": "instock" }, { "checked": false, "label": "Out of stock", "value": "outofstock" } ], "label": "Stock status", "error_position": "bottom-left", "icon": "toggle-down" } }, { "tag": "checkbox", "group": "form_elements", "data": { "name": "product_sold_individually", "email": "Sold individually", "checkbox_items": [ { "checked": false, "image": "", "label": "Enable this to only allow one of this item to be bought in a single order", "value": "yes" } ], "label": "Sold individually", "error_position": "bottom-left", "icon": "check-square-o" } }, { "tag": "divider", "group": "html_elements", "data": { "color": "#444444", "border": "single", "thickness": 1, "height": 1, "border_style": "dashed", "width": "100", "custom_width": "150px", "align": "left", "back": "0", "padding_top": 20, "padding_bottom": 20, "pdfOption": "none" } } ], "data": { "conditional_action": "show", "conditional_trigger": "one", "conditional_items": [ { "field": "product_type", "logic": "equal", "value": "simple", "and_method": "or", "field_and": "product_type", "logic_and": "equal", "value_and": "grouped" }, { "field": "product_type", "logic": "equal", "value": "variable", "and_method": "", "field_and": "product_type", "logic_and": "", "value_and": "" } ] } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "heading", "group": "html_elements", "data": { "title": "Linked Products:" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "text", "group": "form_elements", "data": { "name": "product_upsell_ids", "email": "Product upsells", "label": "Product upsells", "placeholder": "Search for products", "enable_auto_suggest": "true", "retrieve_method": "post_type", "retrieve_method_post": "product", "retrieve_method_value": "id", "error_position": "bottom-left" } }, { "tag": "text", "group": "form_elements", "data": { "name": "product_crosssell_ids", "email": "Product crosssells", "label": "Product crosssells", "placeholder": "Search for products", "enable_auto_suggest": "true", "retrieve_method": "post_type", "retrieve_method_post": "product", "retrieve_method_value": "id", "error_position": "bottom-left" } } ], "data": { "duplicate_limit": 0, "duplicate_dynamically": "true", "label": "Column", "bg_opacity": 1, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } } ], "data": { "duplicate_limit": 0, "duplicate_dynamically": "true", "label": "Column", "bg_opacity": 1, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } }, { "tag": "spacer", "group": "html_elements", "data": { "height": 50, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } } ], "data": { "auto": "no", "prev_text": "Prev", "next_text": "Next", "step_name": "Step 1", "step_description": "Description for this step", "pdfOption": "none" } }, { "tag": "multipart", "group": "layout_elements", "inner": [ { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "heading", "group": "html_elements", "data": { "title": "Shipping:" } }, { "tag": "text", "group": "form_elements", "data": { "name": "product_weight", "email": "Weight (kg)", "label": "Weight (kg)", "type": "text", "validation": "numeric", "may_be_empty": "true", "error_position": "bottom-left" } }, { "tag": "html", "group": "html_elements", "data": { "title": "Dimensions (cm)" } }, { "tag": "text", "group": "form_elements", "data": { "name": "product_length", "email": "Length", "placeholder": "Length", "placeholderFilled": "Length", "type": "text", "validation": "numeric", "may_be_empty": "true", "grouped": "1", "error_position": "bottom-left" } }, { "tag": "text", "group": "form_elements", "data": { "name": "product_width", "email": "Width", "placeholder": "Width", "placeholderFilled": "Width", "type": "text", "validation": "numeric", "may_be_empty": "true", "grouped": "1", "error_position": "bottom-left" } }, { "tag": "text", "group": "form_elements", "data": { "name": "product_height", "email": "Height", "placeholder": "Height", "placeholderFilled": "Height", "type": "text", "validation": "numeric", "may_be_empty": "true", "grouped": "1", "error_position": "bottom-left" } }, { "tag": "dropdown", "group": "form_elements", "data": { "name": "option", "email": "Shipping class", "retrieve_method": "taxonomy", "retrieve_method_taxonomy": "product_shipping_class", "retrieve_method_value": "id", "label": "Shipping class", "placeholder": "- select -", "error_position": "bottom-left", "icon": "toggle-down" } }, { "tag": "divider", "group": "html_elements", "data": { "color": "#444444", "border": "single", "thickness": 1, "height": 1, "border_style": "dashed", "width": "100", "custom_width": "150px", "align": "left", "back": "0", "padding_top": 20, "padding_bottom": 20, "pdfOption": "none" } } ], "data": { "conditional_action": "show", "conditional_items": [ { "field": "product_type", "logic": "equal", "value": "simple", "and_method": "or", "field_and": "product_type", "logic_and": "equal", "value_and": "variable" }, { "field": "product_virtual", "logic": "not_equal", "value": "yes", "and_method": "", "field_and": "product_type", "logic_and": "", "value_and": "" } ] } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "heading", "group": "html_elements", "data": { "title": "Attributes:" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "text", "group": "form_elements", "data": { "name": "product_attributes_name", "email": "Product attribute name", "placeholder": "Product attribute name", "error_position": "bottom-left" } }, { "tag": "checkbox", "group": "form_elements", "data": { "name": "product_attributes_is_visible", "email": "Visible on the product page", "checkbox_items": [ { "checked": false, "image": "", "label": "Visible on the product page", "value": "1" } ], "error_position": "bottom-left", "icon": "check-square-o" } }, { "tag": "checkbox", "group": "form_elements", "data": { "name": "product_attributes_is_variation", "email": "Used for variations", "checkbox_items": [ { "checked": false, "image": "", "label": "Used for variations", "value": "1" } ], "error_position": "bottom-left", "icon": "check-square-o", "conditional_action": "show", "conditional_trigger": "one", "conditional_items": [ { "field": "product_type", "logic": "equal", "value": "variable", "and_method": "", "field_and": "post_title", "logic_and": "", "value_and": "" } ] } } ], "data": { "size": "1/2" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "textarea", "group": "form_elements", "data": { "name": "product_attributes", "email": "Product Attributes", "placeholder": "Product attribute values seperated by pipes e.g: value1|value2|value3", "error_position": "bottom-left", "icon": "question" } } ], "data": { "size": "1/2" } } ], "data": { "duplicate": "enabled" } } ], "data": { "duplicate_limit": 0, "duplicate_dynamically": "true", "label": "Column", "bg_opacity": 1, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } }, { "tag": "spacer", "group": "html_elements", "data": { "height": 50, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } } ], "data": { "auto": "no", "prev_text": "Prev", "next_text": "Next", "step_name": "Step 1", "step_description": "Description for this step", "pdfOption": "none" } }, { "tag": "multipart", "group": "layout_elements", "inner": [ { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "heading", "group": "html_elements", "data": { "title": "Advanced:" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "quantity", "group": "form_elements", "data": { "name": "menu_order", "email": "Menu order", "label": "Menu order", "maxnumber": "9999", "error_position": "bottom-left" } }, { "tag": "checkbox", "group": "form_elements", "data": { "name": "comment_status", "email": "Enable reviews", "checkbox_items": [ { "checked": false, "image": "", "label": "Enable reviews", "value": "open" } ], "error_position": "bottom-left", "icon": "check-square-o" } } ], "data": { "size": "1/3" } }, { "tag": "column", "group": "layout_elements", "inner": [ { "tag": "textarea", "group": "form_elements", "data": { "name": "product_purchase_note", "email": "Purchase note", "placeholder": "Purchase note...", "error_position": "bottom-left", "icon": "question", "conditional_action": "hide", "conditional_trigger": "one", "conditional_items": [ { "field": "product_type", "logic": "equal", "value": "external", "and_method": "", "field_and": "post_title", "logic_and": "", "value_and": "" } ] } } ], "data": { "size": "2/3" } } ], "data": { "duplicate_limit": 0, "duplicate_dynamically": "true", "label": "Column", "bg_opacity": 1, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } }, { "tag": "spacer", "group": "html_elements", "data": { "height": 50, "conditional_action": "disabled", "conditional_trigger": "all", "pdfOption": "none" } } ], "data": { "auto": "no", "prev_text": "Prev", "next_text": "Next", "step_name": "Step 1", "step_description": "Description for this step", "pdfOption": "none" } } ]',
            'settings' => '{ "send": "no", "confirm": "no", "header_content_type": "html", "header_charset": "UTF-8", "admin_attachments": "", "confirm_attachments": "", "email_template": "default_email_template", "save_contact_entry": "no", "save_form_progress": "", "retrieve_last_entry_data": "", "update_contact_entry": "", "form_processing_overlay": "true", "form_show_thanks_msg": "true", "form_thanks_title": "Thank you!", "form_thanks_description": "We will reply within 24 hours.", "form_preload": "1", "form_duration": "500", "form_post_option": "", "form_disable_enter": "", "form_redirect_option": "", "form_hide_after_submitting": "true", "form_clear_after_submitting": "", "form_locker": "", "user_form_locker": "", "theme_style": "", "theme_field_size": "medium", "theme_hide_icons": "yes", "theme_rtl": "", "theme_field_colors_placeholder": "#444444", "adaptive_placeholder_focus": "#4EB1B6", "enable_adaptive_placeholders": "true", "placeholder_adaptive_positioning": "", "adaptive_placeholder_filled": "#9a9a9a", "adaptive_placeholder_bg_top_focus": "#ffffff", "adaptive_placeholder_bg_bottom_focus": "#ffffff", "adaptive_placeholder_bg_top_filled": "#ffffff", "adaptive_placeholder_bg_bottom_filled": "#ffffff", "adaptive_placeholder_border_focus": "", "adaptive_placeholder_border_filled": "", "theme_center_form": "", "theme_max_width": "0", "theme_form_margin": "0px 0px 0px 0px", "theme_ui_loading_icon_font": "#c5c5c5", "theme_field_label": "#444444", "theme_field_description": "#8e8e8e", "theme_ui_checkbox_border": "#4EB1B6", "theme_ui_checkbox_inner": "#4EB1B6", "theme_ui_checkbox_label": "#444444", "theme_ui_dropdown_item_bg": "#ffffff", "theme_ui_dropdown_item_font_focus": "#ffffff", "theme_ui_dropdown_item_bg_focus": "#1E90FF", "theme_ui_dropdown_arrow": "#444444", "theme_ui_quantity_bg": "#4EB1B6", "theme_ui_quantity_font": "#ffffff", "theme_ui_quantity_bg_hover": "#7ed0d4", "theme_ui_quantity_font_hover": "#ffffff", "theme_ui_toggle_bg": "#4EB1B6", "theme_ui_toggle_font": "#ffffff", "theme_ui_toggle_disabled_bg": "#e4e4e4", "theme_ui_toggle_disabled_font": "#9c9c9c", "theme_ui_keywords_bg": "#4EB1B6", "theme_ui_keywords_font": "#ffffff", "theme_ui_keywords_icon": "#2e8a90", "theme_ui_keywords_icon_hover": "#246569", "theme_ui_tags_list_bg_hover": "#fdecde", "theme_ui_slider_dragger": "#4EB1B6", "theme_ui_slider_track": "#CDCDCD", "theme_field_colors_top": "#ffffff", "theme_field_colors_bottom": "#ffffff", "theme_field_colors_border": "#cdcdcd", "theme_field_colors_font": "#444444", "theme_field_colors_top_focus": "#ffffff", "theme_field_colors_bottom_focus": "#ffffff", "theme_field_colors_border_focus": "#cdcdcd", "theme_field_colors_font_focus": "#444444", "theme_field_transparent": "", "theme_rating_color": "#cdcdcd", "theme_rating_bg": "#ffffff", "theme_rating_border": "#cdcdcd", "theme_rating_color_hover": "#f7f188", "theme_rating_bg_hover": "#ffffff", "theme_rating_color_active": "#f7ea00", "theme_rating_bg_active": "#ffffff", "theme_accordion_header": "#ffffff", "theme_accordion_title": "#444444", "theme_accordion_desc": "#444444", "theme_accordion_icon": "#444444", "theme_accordion_content": "#ffffff", "theme_accordion_header_hover": "#ffffff", "theme_accordion_title_hover": "#444444", "theme_accordion_desc_hover": "#444444", "theme_accordion_icon_hover": "#444444", "theme_accordion_header_active": "#ffffff", "theme_accordion_title_active": "#444444", "theme_accordion_desc_active": "#444444", "theme_accordion_icon_active": "#444444", "theme_calc_amount_label_color": "#444444", "theme_calc_amount_currency_color": "#444444", "theme_calc_amount_color": "#444444", "theme_calc_amount_format_color": "#444444", "theme_tooltip_border": "#000000", "theme_tooltip_font": "#FFFFFF", "theme_tooltip_bg": "#444444", "theme_tooltip_arrow_border": "#000000", "theme_tooltip_arrow_bg": "#444444", "theme_multipart_progress_bar": "true", "theme_progress_bar_primary_color": "#ffffff", "theme_progress_bar_secondary_color": "#ffffff", "theme_progress_bar_border_color": "#ffffff", "theme_multipart_steps": "true", "theme_multipart_steps_hide_mobile": "true", "theme_progress_step_primary_color": "#e2e2e2", "theme_progress_step_secondary_color": "#E2E2E2", "theme_progress_step_border_color": "#e2e2e2", "theme_progress_step_font_color": "#FFFFFF", "theme_progress_step_primary_color_active": "#4eb1b6", "theme_progress_step_secondary_color_active": "#4eb1b6", "theme_progress_step_border_color_active": "#4eb1b6", "theme_progress_step_font_color_active": "#FFFFFF", "theme_error_font": "#f2322b", "theme_error_msg_font_color": "#D08080", "theme_error_msg_border_color": "#FFCBCB", "theme_error_msg_bg_color": "#FFEBEB", "theme_error_msg_icon_color": "#FFCBCB", "theme_success_msg_font_color": "#5E7F62", "theme_success_msg_border_color": "#90C397", "theme_success_msg_bg_color": "#C5FFCD", "theme_success_msg_icon_color": "#90C397", "theme_success_msg_margin": "0px 0px 30px 0px", "font_google_fonts": "", "font_global_family": "\"Helvetica\", \"Arial\", sans-serif", "font_global_size": "12", "font_global_lineheight": "1.2", "font_global_weight": "0", "font_label_size": "16", "font_label_lineheight": "1.2", "font_label_weight": "0", "font_description_size": "14", "font_description_lineheight": "1.2", "font_description_weight": "0", "font_global_size_mobile": "16", "font_global_lineheight_mobile": "1.2", "font_global_weight_mobile": "0", "font_label_size_mobile": "20", "font_label_lineheight_mobile": "1.2", "font_label_weight_mobile": "0", "font_description_size_mobile": "16", "font_description_lineheight_mobile": "1.2", "font_description_weight_mobile": "0", "form_custom_css": "", "form_button": "Submit", "form_button_loading": "Loading...", "theme_button_color": "#4eb1b6", "theme_button_color_hover": "#444444", "theme_button_font": "#ffffff", "theme_button_font_hover": "#ffffff", "form_button_radius": "square", "form_button_type": "flat", "form_button_size": "medium", "form_button_align": "left", "form_button_width": "auto", "form_button_icon_option": "none", "csv_attachment_enable": "", "email_reminder_1": "", "email_reminder_2": "", "email_reminder_3": "", "email_reminder_4": "", "email_reminder_5": "", "email_reminder_6": "", "email_reminder_7": "", "frontend_posting_action": "create_post", "frontend_posting_redirect": "", "frontend_posting_post_type": "product", "frontend_posting_status": "publish", "frontend_posting_post_parent": "", "frontend_posting_comment_status": "closed", "frontend_posting_ping_status": "", "frontend_posting_post_password": "", "frontend_posting_menu_order": "", "frontend_posting_meta": "this_is_custom_meta|this_is_custom_meta\nfield_name2|meta_key2\nfield_name3|meta_key3", "frontend_posting_author": "123", "frontend_posting_categories": "product_cat|{tax_input}", "frontend_posting_tags_input": "", "frontend_posting_post_tag_taxonomy": "product_tag", "frontend_posting_post_format": "", "frontend_posting_guid": "", "frontend_posting_product_type": "simple", "frontend_posting_product_attributes": "color|{color}|1|1|1", "frontend_posting_product_featured": "yes", "frontend_posting_product_stock_status": "instock", "frontend_posting_product_manage_stock": "yes", "frontend_posting_product_stock": "12", "frontend_posting_product_backorders": "notify", "frontend_posting_product_sold_individually": "yes", "frontend_posting_product_downloadable": "yes", "frontend_posting_product_virtual": "yes", "frontend_posting_product_visibility": "search", "mailster_enabled": "", "password_protect": "", "password_protect_roles": "", "password_protect_login": "", "password_protect_not_login_hide": "", "paypal_checkout": "", "register_login_action": "none", "woocommerce_checkout": "", "zapier_enable": "", "import-file": "", "popup_enabled": "", "_pdf": { "generate": "false", "debug": "false", "filename": "form.pdf", "emailLabel": "PDF file:", "adminEmail": "true", "confirmationEmail": "true", "excludeEntry": "false", "downloadBtn": "false", "downloadBtnText": "Download Summary", "generatingText": "Generating PDF file...", "orientation": "portrait", "unit": "mm", "format": "a4", "customFormat": "", "margins": { "body": { "top": "0", "right": "5", "bottom": "0", "left": "5" }, "header": { "top": "5", "right": "5", "bottom": "5", "left": "5" }, "footer": { "top": "5", "right": "5", "bottom": "5", "left": "5" } }, "textRendering": "true", "renderScale": "2" } }',
            'date' => '2016-09-05',
        ),
        array( // #17
            'title' => 'Conditional Logic',
            'description' => 'Example form that hides/shows elements and fields with conditional logic',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/conditional-logic/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","error":"Invalid email address!","exclude":"2","icon":"envelope-o"}},{"tag":"dropdown","group":"form_elements","data":{"name":"function","email":"Function:","dropdown_items":[{"checked":false,"label":"- What is your main activity? -","value":""},{"checked":false,"label":"I am a front-end webdeveloper","value":"webdeveloper"},{"checked":false,"label":"I am a back-end programmer","value":"programmer"},{"checked":false,"label":"I am a designer","value":"designer"}],"placeholder":"- What is your main activity? -","validation":"empty","error":"Please make a choice!","icon":"toggle-down"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"checkbox","group":"form_elements","data":{"name":"skills_webdeveloper","email":"Skills:","checkbox_items":[{"checked":false,"image":"","label":"CSS","value":"css"},{"checked":false,"image":"","label":"HTML","value":"html"},{"checked":false,"image":"","label":"JavaScript","value":"javascript"},{"checked":false,"image":"","label":"jQuery","value":"jquery"},{"checked":false,"image":"","label":"I also have these skills:","value":"other"}],"validation":"empty","error":"Choose at least 1 skill!","display":"horizontal","icon":"code","conditional_action":"show","conditional_items":[{"field":"function","logic":"equal","value":"webdeveloper","and_method":"","field_and":"email","logic_and":"","value_and":""}]}},{"tag":"checkbox","group":"form_elements","data":{"name":"skills_programmer","email":"Skills:","checkbox_items":[{"checked":false,"image":"","label":"PHP","value":"php"},{"checked":false,"image":"","label":"MySQL","value":"mysql"},{"checked":false,"image":"","label":"NodeJS","value":"nodejs"},{"checked":false,"image":"","label":"I also have these skills:","value":"other"}],"validation":"empty","error":"Choose at least 1 skill!","display":"horizontal","icon":"code","conditional_action":"show","conditional_items":[{"field":"function","logic":"equal","value":"programmer","and_method":"","field_and":"email","logic_and":"","value_and":""}]}},{"tag":"checkbox","group":"form_elements","data":{"name":"skills_designer","email":"Skills:","checkbox_items":[{"checked":false,"image":"","label":"Photoshop","value":"photoshop"},{"checked":false,"image":"","label":"Indesign","value":"indesign"},{"checked":false,"image":"","label":"Illustrator","value":"illustrator"},{"checked":false,"image":"","label":"I also have these skills:","value":"other"}],"validation":"empty","error":"Choose at least 1 skill!","display":"horizontal","icon":"code","conditional_action":"show","conditional_items":[{"field":"function","logic":"equal","value":"designer","and_method":"","field_and":"email","logic_and":"","value_and":""}]}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"custom_skill","email":"Custom skill:","placeholder":"Skill.....","validation":"empty","error":"Enter your custom skill!","icon":"code"}}],"data":{"duplicate":"enabled","conditional_action":"show","conditional_trigger":"one","conditional_items":[{"field":"skills_webdeveloper","logic":"contains","value":"other","and_method":"","field_and":"email","logic_and":"","value_and":""},{"field":"skills_programmer","logic":"contains","value":"other","and_method":"","field_and":"email","logic_and":"","value_and":""},{"field":"skills_designer","logic":"contains","value":"other","and_method":"","field_and":"email","logic_and":"","value_and":""}]}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"checkbox","group":"form_elements","data":{"name":"newsletter","email":"Newsletter","checkbox_items":[{"checked":false,"image":"","label":"Send me newsletters","value":"yes"}],"display":"horizontal","grouped":"1","icon":"envelope-o"}},{"tag":"text","group":"form_elements","data":{"name":"email_newsletter","email":"Email address:","placeholder":"Your Email Address","validation":"email","grouped":"1","width":"250","conditional_action":"show","conditional_trigger":"one","conditional_items":[{"field":"newsletter","logic":"equal","value":"yes","and_method":"","field_and":"email","logic_and":"","value_and":""}]}}],"data":{"conditional_action":"show","conditional_trigger":"one","conditional_items":[{"field":"function","logic":"not_equal","value":"","and_method":"","field_and":"email","logic_and":"","value_and":""}]}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_recaptcha":"6LegRhMTAAAAAOh3SQk8S-YKmS3HWhuF7PprmtO9","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-05',
        ),
        array( // #1
            'title' => 'Difference Between 2 Times',
            'description' => 'Calculates the difference in hours and minutes between 2 timepickers',
            'requirements' => 'calculator',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/dynamic-fields-with-calculations/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"time","group":"form_elements","data":{"name":"from","email":"Time","placeholder":"From","icon":"clock-o"}}],"data":{"size":"1/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"time","group":"form_elements","data":{"name":"till","email":"Time","placeholder":"Till","icon":"clock-o"}}],"data":{"size":"1/4"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"from_amount","email":"Subtotal:","math":"{from}","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"till_amount","email":"Subtotal:","math":"{till}","decimals":"0","exclude":"2","exclude_entry":"true"}},{"tag":"calculator","group":"form_elements","data":{"name":"diff","email":"Subtotal:","math":"{till}-{from}","decimals":"0","exclude":"2","exclude_entry":"true"}}],"data":{"invisible":"true"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"calculator","group":"form_elements","data":{"name":"hour_diff","email":"Subtotal:","math":"Math.floor({diff}/1000/60/60)","amount_label":"Hours: ","decimals":"0"}},{"tag":"calculator","group":"form_elements","data":{"name":"minute_diff","email":"Subtotal:","math":"Math.floor({diff}/1000/60) - ({hour_diff}*60)","amount_label":"Minutes: ","decimals":"0"}}],"data":{"invisible":"true"}},{"tag":"html","group":"html_elements","data":{"html":"{hour_diff} hours and {minute_diff} minutes."}},{"tag":"spacer","group":"html_elements"}],"data":{"conditional_action":"show","conditional_items":[{"field":"from","logic":"not_equal","value":"","and_method":"and","field_and":"till","logic_and":"not_equal","value_and":""},{"field":"diff","logic":"greater_than","value":"0","and_method":"","field_and":"from","logic_and":"","value_and":""}]}},{"tag":"column","group":"layout_elements","inner":[{"tag":"html","group":"html_elements","data":{"html":"<strong style=\"color:red;\">Please select a later time than your From time.</strong>"}},{"tag":"spacer","group":"html_elements"}],"data":{"conditional_action":"show","conditional_items":[{"field":"from","logic":"not_equal","value":"","and_method":"and","field_and":"till","logic_and":"not_equal","value_and":""},{"field":"diff","logic":"less_than_or_equal","value":"0","and_method":"","field_and":"from","logic_and":"","value_and":""}]}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #2
            'title' => 'Calculate Days Between Dates',
            'description' => 'Calculates the difference in days between 2 datepickers with a margin/range between the 2 dates',
            'requirements' => 'calculator',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/calculate-days-between-dates/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"date","group":"form_elements","data":{"name":"arrival","email":"Arrival:","description":"Connected with departure datepicker","placeholder":"Arrival","connected_min":"departure","connected_min_days":"3","connected_max":"departure","connected_max_days":"12","icon":"calendar"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"date","group":"form_elements","data":{"name":"departure","email":"Departure:","description":"Departure","placeholder":"Departure","icon":"calendar"}}],"data":{"size":"1/2"}},{"tag":"calculator","group":"form_elements","data":{"name":"subtotal","email":"Subtotal:","math":"({departure}-{arrival})/86400000","currency":"Total: ","decimals":"0","thousand_separator":",","icon":"calculator"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #3
            'title' => 'Calculate Age',
            'description' => 'Calculate age based on birthdate',
            'requirements' => 'calculator',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/calculate-age/',
            'elements' => '[{"tag":"date","group":"form_elements","data":{"name":"birthdate","email":"Date","placeholder":"Select a birth date","range":"-100:-5","value":"01-08-1992","return_age":"true","icon":"calendar"}},{"tag":"calculator","group":"form_elements","data":{"name":"subtotal","email":"Subtotal:","math":"{birthdate}","amount_label":"Age: ","decimals":"0"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #5
            'title' => 'HTML with {tags}',
            'description' => 'Example of using {tags} inside a HTML element to retrieve and display user input on the fly',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/html-with-tags/',
            'elements' => '[{"tag":"multipart","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Your Full Name"}},{"tag":"slider","group":"form_elements","data":{"name":"amount","email":"Amount","value":"0","currency":"$","icon":"user"}},{"tag":"calculator","group":"form_elements","data":{"name":"subtotal","email":"Subtotal:","math":"{amount}","currency":"$"}},{"tag":"checkbox","group":"form_elements","data":{"name":"option","email":"Option","checkbox_items":[{"checked":false,"image":"","label":"First choice","value":"first_choice"},{"checked":false,"image":"","label":"Second choice","value":"second_choice"},{"checked":false,"image":"","label":"Third choice","value":"third_choice"}],"confirm_email_value":"label","icon":"check-square-o"}}]},{"tag":"multipart","group":"layout_elements","inner":[{"tag":"heading","group":"html_elements","data":{"title":"Please confirm the below information:"}},{"tag":"html","group":"html_elements","data":{"html":"<strong>Name:</strong> {field_name}<br /><strong>Amount:</strong> {field_amount}<br /><strong>Subtotal:</strong> {subtotal}<br /><strong>Subtotal:</strong> {field_subtotal}<br /><strong>Choice:</strong> {option}"}},{"tag":"spacer","group":"html_elements"}]}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #13
            'title' => 'Form Redirect To Existing Post',
            'description' => 'Redirects the form to an existing post',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/redirect-to-existing-post/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","error":"Invalid email address!","error_position":"bottom-right","icon":"envelope-o"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions...","validation":"empty","error":"Please ask us a question!","error_position":"bottom-right","icon":"question"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"","form_thanks_description":"","form_preload":"1","enable_ajax":"0","form_recaptcha":"6LegRhMTAAAAAOh3SQk8S-YKmS3HWhuF7PprmtO9","form_recaptcha_secret":"","form_redirect_option":"custom","form_redirect":"http:\/\/google.nl","form_redirect_page":"","form_hide_after_submitting":"true","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","csv_attachment_enable":"","csv_attachment_save_as":"admin_email_value","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","password_protect":"","password_protect_password":"xMvODFZ@i76BWsw)H*MaQHTN","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-11-12","popup_till":"2016-11-12","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-09-04',
        ),
        array( // #14
            'title' => 'Form Redirect To Custom URL',
            'description' => 'Redirects the form to a custom URL of your choosing where {tags} can be used to parse user data',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/redirect-to-custom-url/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","error":"Invalid email address!","error_position":"bottom-right","icon":"envelope-o"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions...","validation":"empty","error":"Please ask us a question!","error_position":"bottom-right","icon":"question"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_recaptcha":"6LegRhMTAAAAAOh3SQk8S-YKmS3HWhuF7PprmtO9","form_recaptcha_secret":"","form_redirect_option":"custom","form_redirect":"http:\/\/google.com","form_redirect_page":"456","theme_style":"","theme_max_width":"0","theme_field_label":"#ff5454","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#3f9b4d","theme_button_color_hover":"#007001","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #19
            'title' => 'Google reCAPTCHA',
            'description' => 'BOT spam prevention example with Google reCAPTCHA human verification',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/google-recaptcha/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Your Full Name"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions..."}},{"tag":"checkbox","group":"form_elements","data":{"name":"terms","email":"Terms accepted:","checkbox_items":[{"checked":false,"image":"","label":"I accept the <a href=\"#\">terms of service</a>","value":"yes"}],"validation":"empty","error":"You need to read and accept to our terms of service!","error_position":"bottom-left"}}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"Your Name or Company <info@company.com>","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"custom","confirm_from":"{email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"2d","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #22
            'title' => 'File Upload',
            'description' => 'Form with file/image upload element (browse files from computer)',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/file-upload/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email","placeholder":"Your Email Address","validation":"email","icon":"envelope-o"}},{"tag":"file","group":"form_elements","data":{"name":"file","email":"File","extensions":"jpg|jpeg|png|gif","icon":"download"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"custom","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"File upload received","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"custom","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for sending your documents!","confirm_body":"","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"2d","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #23
            'title' => 'Multipart',
            'description' => 'Multi-part / Multi-step example where form is divided into sections',
            'requirements' => '',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/multi-part/',
            'elements' => '[{"tag":"multipart","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","icon":"envelope-o"}}]},{"tag":"multipart","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"name","email":"Name","placeholder":"Your Full Name"}}]},{"tag":"multipart","group":"layout_elements","inner":[{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions...","icon":"question"}}]}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","form_duration":"500","form_thanks_title":"Thank you for registering!","form_thanks_description":"Please check your email and activate your account!","form_preload":"0","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FF9A9A","theme_success_msg_font_color":"#5e7f62","theme_success_msg_border_color":"#90c397","theme_success_msg_bg_color":"#c5ffcd","theme_success_msg_icon_color":"#90c397","form_button":"Register","theme_button_color":"#000000","theme_button_color_hover":"#007acc","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"register","login_user_role":[""],"register_user_role":"author","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\nYour password: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #24
            'title' => 'MailChimp',
            'description' => 'MailChimp Subscribtion form with optional interests selection',
            'requirements' => 'mailchimp',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/mailchimp/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email","placeholder":"Your Email Address","validation":"email","icon":"envelope"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"first_name","email":"First name:","placeholder":"Your First Name","validation":"empty"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"last_name","email":"Last name:","placeholder":"Your Last Name","validation":"empty"}}],"data":{"size":"1/2"}},{"tag":"mailchimp","group":"form_elements","data":{"list_id":"51616a25b3","send_confirmation":"yes","label":"Interests","description":"Select one or more interests","validation":"empty","display":"horizontal","exclude":"2","icon_position":"inside","icon":"star"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"custom","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"custom","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Subscribe","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"2d","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #26
            'title' => 'Login Form',
            'description' => 'Login form that lets users login from front-end',
            'requirements' => 'register_login',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/login-form/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"user_login","email":"Username","placeholder":"Username","validation":"empty"}},{"tag":"password","group":"form_elements","data":{"name":"user_pass","email":"Password","placeholder":"Password","validation":"empty","icon":"lock"}},{"tag":"activation_code","group":"form_elements","data":{"placeholder":"[-CODE-]","icon":"code","name":"activation_code"}},{"tag":"html","group":"html_elements","data":{"html":"<a style=\"display:block;float:right;\" href=\"http://f4d.nl/super-forms/lost-password/\">Lost Password?</a>"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/2"}}]}]',
            'settings' => '{"header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"no","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"no","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"0","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"custom","form_redirect":"http:\/\/f4d.nl\/super-forms\/lost-password","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FF9A9A","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Login","theme_button_color":"#000000","theme_button_color_hover":"#007acc","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"login","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\nYour password: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #27
            'title' => 'Lost Password Form',
            'description' => 'A front-end password reset/lost form',
            'requirements' => 'register_login',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/lost-password/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"spacer","group":"html_elements","data":{"height":"25"}},{"tag":"divider","group":"html_elements"},{"tag":"spacer","group":"html_elements","data":{"height":"0"}}]},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/5"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"user_email","email":"Email","placeholder":"Email address","validation":"email","error":"Please enter a valid email address!","icon":"envelope"}}],"data":{"size":"1/3"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"button","group":"form_elements","data":{"name":"Reset password"}}],"data":{"size":"1/4"}},{"tag":"column","group":"layout_elements","inner":"","data":{"size":"1/5"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"divider","group":"html_elements"}]}]',
            'settings' => '{"send":"yes","header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_reply_enabled":"","header_reply":"{option_admin_email}","header_reply_name":"{option_blogname}","header_subject":"This mail was send from yourdomain.com","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"yes","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_header_reply_enabled":"","confirm_header_reply":"{option_admin_email}","confirm_header_reply_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","admin_attachments":"","confirm_attachments":"","email_template":"default_email_template","save_contact_entry":"yes","contact_entry_custom_status":"","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","save_form_progress":"","update_contact_entry":"","contact_entry_custom_status_update":"","retrieve_last_entry_data":"","retrieve_last_entry_form":"","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"0","form_duration":"500","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_google_places_api":"","form_post_option":"","form_post_url":"","form_post_custom":"","form_post_parameters":"","form_post_timeout":"5","form_post_http_version":"1.0","form_post_debug":"","form_disable_enter":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_enable_ga_tracking":"","form_ga_code":"","form_ga_tracking":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","form_locker":"","form_locker_limit":10,"form_locker_submission_reset":0,"form_locker_msg":"true","form_locker_msg_title":"Please note:","form_locker_msg_desc":"This form is no longer available","form_locker_hide":"true","form_locker_reset":"","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_center_form":"","theme_rtl":"","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_tags_bg":"#4EB1B6","theme_ui_tags_font":"#ffffff","theme_ui_tags_remove":"#2e8a90","theme_ui_tags_remove_hover":"#246569","theme_ui_tags_list_bg_hover":"#fdecde","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_multipart_progress_bar":"true","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_multipart_steps":"true","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":12,"font_label_size":16,"font_description_size":14,"font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Reset Password","form_button_loading":"Loading...","theme_button_color":"#000000","theme_button_color_hover":"#007acc","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_status":"pending|Pending|#808080|#FFFFFF\nprocessing|Processing|#808080|#FFFFFF\non_hold|On hold|#FF7700|#FFFFFF\naccepted|Accepted|#2BC300|#FFFFFF\ncompleted|Completed|#2BC300|#FFFFFF\ncancelled|Cancelled|#E40000|#FFFFFF\ndeclined|Declined|#E40000|#FFFFFF\nrefunded|Refunded|#000000|#FFFFFF","backend_contact_entry_list_form":"true","backend_contact_entry_list_ip":"","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"yes","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","mailster_enabled":"","mailster_email":"{email}","mailster_fields":"lastname|last_name\nfirstname|first_name","mailster_lists":"{lists}","paypal_checkout":"","paypal_mode":"","paypal_merchant_email":"","paypal_currency_code":"USD","paypal_no_shipping":"0","paypal_payment_type":"_xclick","paypal_item_name":"Flower (roses)","paypal_item_amount":"5.00","paypal_item_quantity":"1","paypal_item_weight":"","paypal_item_number":"","paypal_item_discount_amount":"","paypal_item_discount_rate":"","paypal_item_discount_num":"","paypal_item_shipping":"","paypal_item_shipping2":"","paypal_subscription_periods":"","paypal_cart_items":"","paypal_tax_cart":"","paypal_weight_cart":"","paypal_discount_amount_cart":"","paypal_discount_rate_cart":"","paypal_handling_cart":"","paypal_custom_return_url":"","paypal_return_url":"http:\/\/f4d.nl\/dev\/my-custom-thank-you-page","paypal_cancel_url":"http:\/\/f4d.nl\/dev\/my-custom-canceled-page","paypal_advanced_settings":"","paypal_lc":"US","paypal_charset":"UTF-8","paypal_handling":"","paypal_undefined_quantity":"","paypal_weight_unit":"lbs","paypal_invoice":"","paypal_night_phone_a":"","night_phone_b":"","night_phone_c":"","paypal_custom_address":"","paypal_address_override":"","paypal_first_name":"","paypal_last_name":"","paypal_email":"","paypal_address1":"","paypal_address2":"","paypal_city":"","paypal_state":"","paypal_zip":"","paypal_country":"","paypal_completed_entry_status":"completed","paypal_notify_url":"","paypal_completed_post_status":"publish","paypal_completed_signup_status":"active","register_login_action":"reset_password","register_login_register_not_logged_in":"","register_login_user_id_update":"","register_login_action_skip_register":"","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_send_approve_email":"","register_approve_subject":"Account has been approved","register_approve_email":"Dear {user_login},\n\nYour account has been approved and can now be used!\n\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{user_pass}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login into your account.\n\n\nBest regards,\n\n{option_blogname}","register_approve_generate_pass":"","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_login_multisite_enabled":"","register_login_multisite_domain":"{user_email}","register_login_multisite_path":"{user_email}","register_login_multisite_title":"{user_email}","register_login_multisite_id":"1","register_login_multisite_email":"true","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","register_login_not_logged_in_msg":"You must be logged in to submit this form. Click <a href=\"{register_login_url}\">here<\/a> to login!","register_login_update_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_checkout_fields":"","woocommerce_checkout_fields_skip_empty":"","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","zapier_enable":"","zapier_webhook":"","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2017-12-31","popup_till":"2017-12-31","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no_repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307"}',
            'date' => '2016-09-04',
        ),
        array( // #28
            'title' => 'Email Templates',
            'description' => 'Example form with custom email template options',
            'requirements' => 'email_templates',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/email-templates/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"first_name","email":"First name:","placeholder":"Your First Name","validation":"empty"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"last_name","email":"Last name:","placeholder":"Your Last Name","validation":"empty"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","placeholder":"Your Email Address","validation":"email","icon":"envelope"}},{"tag":"textarea","group":"form_elements","data":{"name":"question","email":"Question","placeholder":"Ask us any questions...","icon":"question"}}]}]',
            'settings' => '{"header_to":"{email}","header_from_type":"default","header_from":"Your Name or Company <info@company.com>","header_from_name":"{option_blogname}","header_subject":"Question received from {field_first_name} {field_last_name}","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"A user just tested the Add-on on our website. How awesome is that! More information about this Add-on can be found <a href=\"http:\/\/f4d.nl\/super-forms\/add-ons\/email-templates\/\">here<\/a>.\n\nThe following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"custom","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"We are glad you tried out this Add-on.\nAll colors can be changed with simple color pickers!\nMore information can be found <a href=\"http:\/\/f4d.nl\/super-forms\/add-ons\/email-templates\/\">here<\/a>.","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}\n\n.","email_template":"email_template_1","email_template_1_logo":"994","email_template_1_title":"24h Support","email_template_1_confirm_title":"24h Support","email_template_1_subtitle":"Thank you {field_first_name}!","email_template_1_confirm_subtitle":"Thank you {field_first_name}!","email_template_1_copyright":"© Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|http:\/\/f4d.nl\/super-forms\/wp-content\/uploads\/2016\/05\/twitter-icon.png\nhttp:\/\/facebook.com\/company|http:\/\/f4d.nl\/super-forms\/wp-content\/uploads\/2016\/05\/facebook-icon.png\nhttp:\/\/linkedin.com\/company|http:\/\/f4d.nl\/super-forms\/wp-content\/uploads\/2016\/05\/linked-in.png","email_template_1_header_bg_color":"#dae9fe","email_template_1_header_title_color":"#1962ab","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#444444","email_template_1_body_font_color":"#444444","email_template_1_footer_bg_color":"#3a9f64","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","form_duration":"500","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","form_redirect_option":"","form_redirect":"","form_redirect_page":"","theme_style":"","theme_max_width":"0","theme_hide_icons":"yes","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","form_button":"Submit","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","mailchimp_key":"","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}"}',
            'date' => '2016-09-04',
        ),
        array( // #29
            'title' => 'Signature Form',
            'description' => 'Form that needs to be signed by 2 people',
            'requirements' => 'signature',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/signature/',
            'elements' => '[{"tag":"column","group":"layout_elements","inner":[{"tag":"text","group":"form_elements","data":{"name":"email","email":"Email address:","description":"Enter your personal email address!","placeholder":"Your Email Address","validation":"email","error":"Invalid email address!"}}]},{"tag":"column","group":"layout_elements","inner":[{"tag":"signature","group":"form_elements","data":{"name":"signature2","email":"Signature college 2","description":"Signature college 2","thickness":"2","validation":"empty","error":"Please sign here","width":"0","height":"100"}}],"data":{"size":"1/2"}},{"tag":"column","group":"layout_elements","inner":[{"tag":"signature","group":"form_elements","data":{"name":"signature1","email":"Signature college 1","description":"Signature college 1","thickness":"1","bg_size":"0","validation":"empty","error":"Please sign here","width":"0","height":"100"}}],"data":{"size":"1/2"}}]',
            'settings' => '{"header_to":"{email}","header_from_type":"custom","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_subject":"Super Forms","header_content_type":"html","header_charset":"UTF-8","header_cc":"","header_bcc":"","header_additional":"","send":"yes","email_body_open":"The following information has been send by the submitter:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","confirm":"yes","confirm_to":"{email}","confirm_from_type":"custom","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","email_template":"default_email_template","email_template_1_logo":"","email_template_1_title":"Your title","email_template_1_confirm_title":"Your title","email_template_1_subtitle":"Your subtitle","email_template_1_confirm_subtitle":"Your subtitle","email_template_1_copyright":"\u00a9 Someone, somewhere 2016","email_template_1_socials":"http:\/\/twitter.com\/company|url_to_social_icon","email_template_1_header_bg_color":"#5ba1d3","email_template_1_header_title_color":"#ffffff","email_template_1_body_bg_color":"#ffffff","email_template_1_body_subtitle_color":"#474747","email_template_1_body_font_color":"#9e9e9e","email_template_1_footer_bg_color":"#ee4c50","email_template_1_footer_font_color":"#ffffff","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank you!","form_thanks_description":"We will reply within 24 hours.","form_preload":"1","enable_ajax":"0","form_recaptcha":"","form_recaptcha_secret":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","theme_style":"","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#cdcdcd","theme_icon_color_focus":"#444444","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_currency_color":"#139307","theme_amount_color":"#139307","theme_quantity_color":"#ff0000","theme_percentage_color":"#139307","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","form_custom_css":"","form_button":"Subscribe!","form_button_loading":"Loading...","theme_button_color":"#346582","theme_button_color_hover":"#47a7b2","theme_button_font":"#346582","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"outline","form_button_size":"big","form_button_align":"right","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"meh-o","backend_contact_entry_list_fields":"email|Email\nphonenumber|Phonenumber\nmessage|Message","backend_contact_entry_list_form":"true","theme_custom_css":"","smtp_enabled":"disabled","smtp_host":"smtp1.example.com;smtp2.example.com","smtp_auth":"disabled","smtp_username":"","smtp_password":"","smtp_secure":"","smtp_port":"465","smtp_timeout":30,"smtp_keep_alive":"disabled","smtp_debug":0,"smtp_debug_output_mode":"echo","csv_attachment_enable":"","csv_attachment_save_as":"admin_email_value","frontend_posting_action":"none","frontend_posting_post_type":"page","frontend_posting_status":"publish","frontend_posting_post_parent":"","frontend_posting_comment_status":"","frontend_posting_ping_status":"","frontend_posting_post_password":"","frontend_posting_menu_order":"","frontend_posting_meta":"field_name|meta_key\nfield_name2|meta_key2\nfield_name3|meta_key3","frontend_posting_author":"","frontend_posting_post_cat_taxonomy":"","frontend_posting_tax_input":"","frontend_posting_tags_input":"","frontend_posting_post_tag_taxonomy":"","frontend_posting_post_format":"","frontend_posting_guid":"","frontend_posting_product_type":"","frontend_posting_product_featured":"no","frontend_posting_product_stock_status":"instock","frontend_posting_product_manage_stock":"no","frontend_posting_product_stock":"0","frontend_posting_product_backorders":"no","frontend_posting_product_sold_individually":"no","frontend_posting_product_downloadable":"no","frontend_posting_product_virtual":"no","frontend_posting_product_visibility":"visible","mailchimp_key":"","password_protect":"","password_protect_password":"xMvODFZ@i76BWsw)H*MaQHTN","password_protect_incorrect_msg":"Incorrect password, please try again!","password_protect_roles":"","password_protect_user_roles":"","password_protect_hide":"","password_protect_show_msg":"true","password_protect_msg":"You do not have permission to submit this form!","password_protect_login":"","password_protect_login_hide":"","password_protect_show_login_msg":"true","password_protect_login_msg":"You are currently not logged in. In order to submit the form make sure you are logged in!","register_login_action":"none","login_user_role":[""],"register_user_role":"administrator","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/super-forms\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"first_name|billing_first_name\nlast_name|billing_last_name\naddress|billing_address","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","woocommerce_checkout":"","woocommerce_checkout_empty_cart":"","woocommerce_checkout_remove_coupons":"","woocommerce_checkout_remove_fees":"","woocommerce_checkout_products":"{id}|{quantity}|none|{price}","woocommerce_checkout_coupon":"","woocommerce_checkout_fees":"{fee_name}|{amount}|{taxable}|{tax_class}","woocommerce_redirect":"checkout","woocommerce_post_status":"publish","woocommerce_signup_status":"active","popup_enabled":"","popup_logged_in":"true","popup_not_logged_in":"true","popup_page_load":"true","popup_exit_intent":"","popup_leave":"","popup_leave_msg":"Wait stay with us! Please take the time to fill out our form!?","popup_enable_scrolling":"","popup_scrolled":"0","popup_enable_seconds":"","popup_seconds":"0","popup_enable_inactivity":"","popup_inactivity":"0","popup_enable_schedule":"","popup_from":"2016-11-12","popup_till":"2016-11-12","popup_disable_closing":"","popup_close_btn":"true","popup_close_btn_icon_color":"#fff","popup_close_btn_bg_color":"#00bc65","popup_close_btn_label":"","popup_close_btn_label_color":"#00bc65","popup_close_btn_label_bg_color":"#00bc65","popup_close_btn_label_padding":"","popup_close_btn_icon_size":"14","popup_close_btn_border":"0","popup_close_btn_border_color":"","popup_close_btn_top":"0","popup_close_btn_right":"0","popup_close_btn_padding":"","popup_close_btn_radius":"0","popup_enable_padding":"","popup_padding":"","popup_expire_trigger":"","popup_expire":"1","popup_width":"700","popup_background_color":"#ffffff","popup_overlay_color":"#000000","popup_overlay_opacity":"0.5","popup_background_image":"0","popup_background_image_repeat":"no-repeat","popup_background_image_size":"cover","popup_slide":"none","popup_slide_duration":"300","popup_fade_duration":"300","popup_fade_out_duration":"300","popup_sticky":"default","popup_enable_borders":"","popup_border_size":"0","popup_border_color":"#00bc65","popup_border_radius_top_left":"10","popup_border_radius_top_right":"10","popup_border_radius_bottom_left":"10","popup_border_radius_bottom_right":"10","popup_enable_shadows":"","popup_shadow_horizontal_length":"5","popup_shadow_vertical_length":"5","popup_blur_radius":"15","popup_spread_radius":"3","popup_shadow_color":"#000000","popup_shadow_opacity":"0.7"}',
            'date' => '2016-09-04',
        ),
        array( // #52
            'title' => 'Register Form',
            'description' => 'Allows users to register from front-end',
            'requirements' => 'register_login',
            'live_preview' => 'http://f4d.nl/super-forms/live-preview-marketplace/register-form/',
            'elements' => '[{"tag":"text","group":"form_elements","data":{"name":"user_login","email":"Username","placeholder":"Username","validation":"empty"}},{"tag":"text","group":"form_elements","data":{"name":"user_email","email":"Email address:","placeholder":"Email address","validation":"email","icon":"envelope"}},{"tag":"text","group":"form_elements","data":{"name":"repeat_email","email":"Email address:","placeholder":"Repeat email address","validation":"email","conditional_validation":"equal","conditional_validation_value":"{user_email}","error":"Email address did not match!","exclude":"2","icon":"envelope"}},{"tag":"password","group":"form_elements","data":{"name":"user_pass","email":"Password","placeholder":"Password","icon":"lock"}},{"tag":"password","group":"form_elements","data":{"name":"confirm_pass","placeholder":"Repeat password","validation":"empty","conditional_validation":"equal","conditional_validation_value":"{user_pass}","exclude":"2","icon":"lock"}}]',
            'settings' => '{"send":"yes","header_to":"{option_admin_email}","header_from_type":"default","header_from":"{option_admin_email}","header_from_name":"{option_blogname}","header_reply_enabled":"","header_reply":"{option_admin_email}","header_reply_name":"{option_blogname}","header_subject":"New user registered","email_body_open":"The following user just registered:","email_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","email_body_close":"Best regards, {option_blogname}","email_loop":"<tr><th valign=\"top\" align=\"right\">{loop_label}<\/th><td>{loop_value}<\/td><\/tr>","email_body_nl2br":"true","header_cc":"","header_bcc":"","header_additional":"","confirm":"no","confirm_to":"{email}","confirm_from_type":"default","confirm_from":"{option_admin_email}","confirm_from_name":"{option_blogname}","confirm_header_reply_enabled":"","confirm_header_reply":"{option_admin_email}","confirm_header_reply_name":"{option_blogname}","confirm_subject":"Thank you!","confirm_body_open":"Dear user,\n\nThank you for contacting us!","confirm_body":"<table cellpadding=\"5\">{loop_fields}<\/table>","confirm_body_close":"We will reply within 48 hours.\n\nBest Regards, {option_blogname}","confirm_body_nl2br":"true","confirm_header_cc":"","confirm_header_bcc":"","confirm_header_additional":"","header_content_type":"html","header_charset":"UTF-8","email_template":"default_email_template","save_contact_entry":"yes","enable_custom_entry_title":"","contact_entry_title":"Contact entry","contact_entry_add_id":"","save_form_progress":"","update_contact_entry":"","retrieve_last_entry_data":"","retrieve_last_entry_form":"","form_duration":"500","form_show_thanks_msg":"true","form_thanks_title":"Thank for registering!","form_thanks_description":"Please check your inbox to activate your account","form_preload":"1","form_post_option":"","form_post_url":"","form_redirect_option":"","form_redirect":"","form_redirect_page":"","form_hide_after_submitting":"true","form_clear_after_submitting":"","theme_style":"","theme_field_size":"medium","theme_hide_icons":"yes","theme_rtl":"","theme_icon_color":"#B3DBDD","theme_icon_color_focus":"#4EB1B6","theme_icon_bg":"#ffffff","theme_icon_bg_focus":"#ffffff","theme_icon_border":"#cdcdcd","theme_icon_border_focus":"#cdcdcd","theme_ui_loading_icon_font":"#c5c5c5","theme_field_label":"#444444","theme_field_description":"#8e8e8e","theme_ui_checkbox_border":"#4EB1B6","theme_ui_checkbox_inner":"#4EB1B6","theme_ui_checkbox_label":"#444444","theme_ui_quantity_bg":"#4EB1B6","theme_ui_quantity_font":"#ffffff","theme_ui_quantity_bg_hover":"#7ed0d4","theme_ui_quantity_font_hover":"#ffffff","theme_ui_toggle_bg":"#4EB1B6","theme_ui_toggle_font":"#ffffff","theme_ui_toggle_disabled_bg":"#e4e4e4","theme_ui_toggle_disabled_font":"#9c9c9c","theme_ui_keywords_bg":"#4EB1B6","theme_ui_keywords_font":"#ffffff","theme_ui_keywords_icon":"#2e8a90","theme_ui_keywords_icon_hover":"#246569","theme_ui_slider_dragger":"#4EB1B6","theme_ui_slider_track":"#CDCDCD","theme_field_colors_top":"#ffffff","theme_field_colors_bottom":"#ffffff","theme_field_colors_border":"#cdcdcd","theme_field_colors_font":"#444444","theme_field_colors_placeholder":"#444444","theme_field_colors_top_focus":"#ffffff","theme_field_colors_bottom_focus":"#ffffff","theme_field_colors_border_focus":"#cdcdcd","theme_field_colors_font_focus":"#444444","theme_field_colors_placeholder_focus":"#444444","theme_field_transparent":"","theme_rating_color":"#cdcdcd","theme_rating_bg":"#ffffff","theme_rating_border":"#cdcdcd","theme_rating_color_hover":"#f7f188","theme_rating_bg_hover":"#ffffff","theme_rating_color_active":"#f7ea00","theme_rating_bg_active":"#ffffff","theme_progress_bar_primary_color":"#87CC83","theme_progress_bar_secondary_color":"#E2E2E2","theme_progress_bar_border_color":"#CECECE","theme_progress_step_primary_color":"#CECECE","theme_progress_step_secondary_color":"#E2E2E2","theme_progress_step_border_color":"#CECECE","theme_progress_step_font_color":"#FFFFFF","theme_progress_step_primary_color_active":"#87CC83","theme_progress_step_secondary_color_active":"#E2E2E2","theme_progress_step_border_color_active":"#CECECE","theme_progress_step_font_color_active":"#FFFFFF","theme_error_font":"#f2322b","theme_error_msg_font_color":"#D08080","theme_error_msg_border_color":"#FFCBCB","theme_error_msg_bg_color":"#FFEBEB","theme_error_msg_icon_color":"#FFCBCB","theme_success_msg_font_color":"#5E7F62","theme_success_msg_border_color":"#90C397","theme_success_msg_bg_color":"#C5FFCD","theme_success_msg_icon_color":"#90C397","theme_success_msg_margin":"0px 0px 30px 0px","theme_max_width":"0","theme_form_margin":"0px 0px 0px 0px","font_global_size":"12","font_label_size":"16","font_description_size":"14","font_google_fonts":"","font_global_family":"","form_custom_css":"","form_button":"Submit","form_button_loading":"Loading...","theme_button_color":"#f26c68","theme_button_color_hover":"#444444","theme_button_font":"#ffffff","theme_button_font_hover":"#ffffff","form_button_radius":"square","form_button_type":"flat","form_button_size":"medium","form_button_align":"left","form_button_width":"auto","form_button_icon_option":"none","form_button_icon_visibility":"visible","form_button_icon_animation":"horizontal","form_button_icon":"","register_login_action":"register","register_login_action_skip_register":"","login_user_role":[""],"register_user_role":"subscriber","register_user_signup_status":"active","register_login_activation":"verify","register_login_url":"http:\/\/f4d.nl\/dev\/login\/","register_welcome_back_msg":"Welcome back {field_user_login}!","register_incorrect_code_msg":"The combination username, password and activation code is incorrect!","register_account_activated_msg":"Hello {field_user_login}, your account has been activated!","register_activation_subject":"Activate your account","register_activation_email":"Dear {field_user_login},\n\nThank you for registering! Before you can login you will need to activate your account.\nBelow you will find your activation code. You need this code to activate your account:\n\nActivation Code: <strong>{register_activation_code}<\/strong>\n\nClick <a href=\"{register_login_url}?code={register_activation_code}\">here<\/a> to activate your account with the provided code.\n\n\nBest regards,\n\n{option_blogname}","register_login_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state","register_login_multisite_enabled":"","register_login_multisite_domain":"{user_email}","register_login_multisite_path":"{user_email}","register_login_multisite_title":"{user_email}","register_login_multisite_id":"1","register_login_multisite_email":"true","register_reset_password_success_msg":"Your password has been reset. We have just send you a new password to your email address.","register_reset_password_not_exists_msg":"We couldn\'t find a user with the given email address!","register_reset_password_subject":"Your new password","register_reset_password_email":"Dear {user_login},\n\nYou just requested to reset your password.\nUsername: <strong>{user_login}<\/strong>\nPassword: <strong>{register_generated_password}<\/strong>\n\nClick <a href=\"{register_login_url}\">here<\/a> to login with your new password.\n\n\nBest regards,\n\n{option_blogname}","register_login_not_logged_in_msg":"You must be logged in to submit this form. Click <a href=\"{register_login_url}\">here<\/a> to login!","register_login_update_user_meta":"billing_first_name|billing_first_name\nbilling_last_name|billing_last_name\nbilling_company|billing_company\nbilling_address_1|billing_address_1\nbilling_address_2|billing_address_2\nbilling_city|billing_city\nbilling_postcode|billing_postcode\nbilling_country|billing_country\nbilling_state|billing_state\nbilling_phone|billing_phone\nbilling_email|billing_email\nshipping_first_name|shipping_first_name\nshipping_last_name|shipping_last_name\nshipping_company|shipping_company\nshipping_address_1|shipping_address_1\nshipping_address_2|shipping_address_2\nshipping_city|shipping_city\nshipping_postcode|shipping_postcode\nshipping_country|shipping_country\nshipping_state|shipping_state"}',
            'date' => '2016-09-04',
        ),
    );
    ?>

    <div class="wp-list-table widefat plugin-install">
        <h2 class="screen-reader-text">Forms list</h2>
        <div id="the-list">
            <?php
            foreach( $forms as $k => $v ) {
                ?>
                <div class="plugin-card">
                    <input type="hidden" name="title" value="<?php echo $v['title']; ?>" />
                    <textarea style="display:none;" name="_super_form_settings"><?php if( !empty( $v['settings'] ) ) echo $v['settings']; ?></textarea>
                    <textarea style="display:none;" name="_super_elements"><?php if( !empty( $v['elements'] ) ) echo $v['elements']; ?></textarea>
                    <textarea style="display:none;" name="_super_import"><?php if( !empty( $v['import'] ) ) echo $v['import']; ?></textarea>
                    <div class="plugin-card-top">
                        <div class="name column-name">
                            <h3>
                                <?php
                                //echo '<a href="' . $v['live_preview'] . '?TB_iframe=true&width=700&height=550" class="thickbox">';
                                echo $v['title'];
                                //echo '</a>';
                                ?>
                            </h3>
                        </div>
                        <div class="action-links">
                            <ul class="plugin-action-buttons">
                                <li>
                                    <?php
                                    echo '<span class="install-now button">Install Now</span>';
                                    ?>
                                </li>
                                <li>
                                    <?php 
                                    //if(!empty($v['live_preview'])) { 
                                        //echo '<a target="_blank" href="' . $v['live_preview'] . '">Live Preview</a>';
                                    //} 
                                    ?>
                                </li>
                            </ul>
                        </div>
                        <div class="desc column-description">
                            <?php
                                echo '<p>' . $v['description'] . '</p>';
                            ?>
                        </div>
                    </div>
                    <div class="plugin-card-bottom">
                        <?php
                        /*
                        <div class="column-updated">
                            <strong>Created on:</strong> <?php echo date_i18n('d M, Y', strtotime($v['date'])); ?>
                        </div>
                        */
                        ?>
                        <div class="column-compatibility">
                            <span class="compatibility-compatible">
                                <strong>Requirements:</strong>
                                <?php 
                                if( !empty($v['requirements']) ) {
                                    $requirements = explode(',', $v['requirements']);
                                    foreach($requirements as $rk => $rv){
                                        if(empty($add_ons[$rv])) {
                                            echo $rv . '<br />';
                                        }else{
                                            if(!empty($add_ons[$rv]['url'])) {
                                                echo '<a href="' . $add_ons[$rv]['url'] . '" target="_blank">' . $add_ons[$rv]['title'] . '</a><br />';
                                            }else{
                                                echo $add_ons[$rv]['title'].'<br />';
                                            }
                                        }
                                    }
                                }else{
                                    echo esc_html__( 'None', 'super-forms' );
                                }
                                ?>
                            </span>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
    </div>
    
    <br class="clear">

</div>
